/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.ui;

import com.devexperts.logging.Logging;
import com.rusefi.autoupdate.ReportedIOException;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.core.ui.ProgressView;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoupdateUtil {
    private static final Logging log = Logging.getLogging(AutoupdateUtil.class);
    public static final boolean runHeadless = Boolean.getBoolean("run_headless") || GraphicsEnvironment.isHeadless();
    private static final String APPICON = "/appicon.png";
    private static final DynamicForResourcesURLClassLoader dynamicResourcesLoader = new DynamicForResourcesURLClassLoader(AutoupdateUtil.class.getClassLoader());

    public static JComponent wrap(JComponent component) {
        AutoupdateUtil.assertAwtThread();
        JPanel result = new JPanel();
        result.add(component);
        return result;
    }

    private static ProgressView doCreateProgressView(String title) {
        if (runHeadless) {
            return new ProgressView(null, null);
        }
        FrameHelper frameHelper = new FrameHelper();
        AutoupdateUtil.setAppIcon(frameHelper.getFrame());
        JProgressBar jProgressBar = new JProgressBar();
        frameHelper.getFrame().setTitle(title);
        jProgressBar.setMaximum(100);
        frameHelper.showFrame(jProgressBar, true);
        return new ProgressView(frameHelper, jProgressBar);
    }

    public static void downloadAutoupdateFile(String localZipFileName, ConnectionAndMeta connectionAndMeta, String title) throws IOException {
        ProgressView view = AutoupdateUtil.createProgressView(title);
        try {
            ConnectionAndMeta.DownloadProgressListener listener = currentProgress -> {
                if (!runHeadless) {
                    SwingUtilities.invokeLater(() -> view.getProgressBar().setValue(currentProgress));
                }
            };
            ConnectionAndMeta.downloadFile(localZipFileName, connectionAndMeta, listener);
        }
        catch (IOException e) {
            if (view.getProgressBar() != null) {
                String message = e instanceof UnknownHostException ? "Please fix your internet connection" : "Error downloading: " + e;
                JOptionPane.showMessageDialog(view.getProgressBar(), message, "Error", 0);
                throw new ReportedIOException(e);
            }
            throw e;
        }
        finally {
            view.dispose();
        }
    }

    private static ProgressView createProgressView(String title) {
        AtomicReference result = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(() -> result.set(AutoupdateUtil.doCreateProgressView(title)));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (ProgressView)result.get();
    }

    @NotNull
    public static URLClassLoader getClassLoaderByJar(String jar) throws MalformedURLException {
        URL jarURL = new File(jar).toURI().toURL();
        dynamicResourcesLoader.addURL(jarURL);
        return new URLClassLoader(new URL[]{new File(jar).toURI().toURL()}, (ClassLoader)dynamicResourcesLoader);
    }

    public static void trueLayoutAndRepaint(Component component) {
        AutoupdateUtil.assertAwtThread();
        if (component == null) {
            return;
        }
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static Window getSelectedWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isActive()) {
                return window;
            }
            Window[] ownedWindows = window.getOwnedWindows();
            if (ownedWindows == null) continue;
            return AutoupdateUtil.getSelectedWindow(ownedWindows);
        }
        return null;
    }

    public static void assertNotAwtThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            AutoupdateUtil.showError("Non AWT thread expected");
        }
    }

    public static void assertAwtThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            AutoupdateUtil.showError("Not on AWT thread but " + Thread.currentThread().getName());
        }
    }

    private static void showError(String error) {
        IllegalStateException e = new IllegalStateException(error);
        StringBuilder trace = new StringBuilder(e + "\n");
        for (StackTraceElement element : e.getStackTrace()) {
            trace.append(element.toString()).append("\n");
        }
        SwingUtilities.invokeLater(() -> {
            Window w = AutoupdateUtil.getSelectedWindow(Window.getWindows());
            JOptionPane.showMessageDialog(w, trace, "Error", 0);
        });
    }

    public static boolean hasExistingFile(String zipFileName, long completeFileSize, long lastModified) {
        File file = new File(zipFileName);
        System.out.println("We have size=" + file.length() + " modified=" + new Date(file.lastModified()) + " " + file.getAbsolutePath());
        return file.length() == completeFileSize && file.lastModified() == lastModified;
    }

    public static ImageIcon loadIcon(String strPath) {
        URL imgURL = dynamicResourcesLoader.getResource(strPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        log.info("Using secondary resource path for " + strPath);
        imgURL = dynamicResourcesLoader.getResource("/com/rusefi/" + strPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        log.warn("icon resource not found " + strPath);
        return null;
    }

    public static void setAppIcon(JFrame frame) {
        ImageIcon icon = AutoupdateUtil.loadIcon(APPICON);
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
    }

    public static void pack(Window window) {
        AutoupdateUtil.trueLayoutAndRepaint(window);
        if (window != null) {
            window.pack();
        }
        AutoupdateUtil.trueLayoutAndRepaint(window);
    }

    private static class DynamicForResourcesURLClassLoader
    extends URLClassLoader {
        public DynamicForResourcesURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        @Nullable
        public URL getResource(String name) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return super.getResource(name);
        }
    }
}

