/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5;

import com.opensr5.ini.field.EnumIniField;
import com.rusefi.config.FieldType;
import com.rusefi.core.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ConfigurationImage {
    private final byte[] content;

    public ConfigurationImage(int size) {
        this.content = new byte[size];
    }

    public ConfigurationImage(byte[] content) {
        this.content = Objects.requireNonNull(content);
    }

    public static void setScalarValue(ByteBuffer wrapped, FieldType type, String value, int bitOffset, double multiplier, double serializationOffset) {
        double v = (Double.parseDouble(value) - serializationOffset) / multiplier;
        if (bitOffset != -1) {
            throw new UnsupportedOperationException("For " + value);
        }
        if (type == FieldType.INT8 || type == FieldType.UINT8) {
            wrapped.put((byte)Math.round(v));
        } else if (type == FieldType.INT) {
            wrapped.putInt((int)Math.round(v));
        } else if (type == FieldType.INT16 || type == FieldType.UINT16) {
            wrapped.putShort((short)Math.round(v));
        } else {
            wrapped.putFloat((float)v);
        }
    }

    public static int getBitRange(int ordinal, int bitPosition, int bitSize) {
        ordinal >>= bitPosition;
        return ordinal &= (1 << bitSize) - 1;
    }

    public static boolean getBit(int ordinal, int bitPosition) {
        return ConfigurationImage.getBitRange(ordinal, bitPosition, 1) == 1;
    }

    public void setBitValue(EnumIniField enumIniField, int ordinal) {
        int value = this.getByteBuffer(enumIniField).getInt();
        value = EnumIniField.setBitRange(value, ordinal, enumIniField.getBitPosition(), enumIniField.getBitSize0() + 1);
        this.getByteBuffer(enumIniField).putInt(value);
    }

    @NotNull
    public ByteBuffer getByteBuffer(int offset, int size) {
        return ByteBufferUtil.littleEndianWrap(this.content, offset, size);
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public int getSize() {
        return this.content.length;
    }

    public byte[] getContent() {
        return this.content;
    }

    public ConfigurationImage clone() {
        byte[] copy = (byte[])this.content.clone();
        return new ConfigurationImage(copy);
    }

    public byte[] getRange(int offset, int size) {
        byte[] r = new byte[size];
        System.arraycopy(this.content, offset, r, 0, size);
        return r;
    }

    public String toString() {
        return "ConfigurationImage{size=" + this.content.length + '}';
    }

    @NotNull
    public ByteBuffer getByteBuffer(EnumIniField enumIniField) {
        Objects.requireNonNull(this, "image enum getter");
        if (this.getSize() < enumIniField.getOffset() + 4) {
            throw new IllegalArgumentException("OutOfBounds while " + enumIniField.getName() + " " + enumIniField.getOffset());
        }
        return this.getByteBuffer(enumIniField.getOffset(), 4);
    }
}

