/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.IniFieldVisitor;
import com.opensr5.ini.field.OrdinalOutOfRangeException;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.config.Field;
import com.rusefi.config.StringFormatter;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ConfigurationImageGetterSetter {
    public static String getValue(IniField iniField, final ConfigurationImage image) {
        return iniField.accept(new IniFieldVisitor<String>(){

            @Override
            public String visit(ScalarIniField field) {
                Field f = new Field(field.getName(), field.getOffset(), field.getType());
                try {
                    Double value = f.getValue(image, field.getMultiplier()) + field.getSerializationOffset();
                    return StringFormatter.niceToString(value, 5);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("While getting " + field.getName(), e);
                }
            }

            @Override
            public String visit(EnumIniField field) {
                int ordinal = image.getByteBuffer(field).getInt();
                if ((ordinal = ConfigurationImage.getBitRange(ordinal, field.getBitPosition(), field.getBitSize0() + 1)) >= field.getEnums().size()) {
                    throw new OrdinalOutOfRangeException("Ordinal out of range " + ordinal + " in " + field.getName() + " while " + field.getEnums().size() + " " + (Object)((Object)field.getType()));
                }
                return "\"" + field.getEnums().get(ordinal) + "\"";
            }

            @Override
            public String visit(ArrayIniField field) {
                String[][] values = new String[field.getRows()][field.getCols()];
                for (int rowIndex = 0; rowIndex < field.getRows(); ++rowIndex) {
                    for (int colIndex = 0; colIndex < field.getCols(); ++colIndex) {
                        Field f = new Field(field.getName() + "_" + colIndex, field.getOffset(rowIndex, colIndex), field.getType());
                        values[rowIndex][colIndex] = f.getAnyValue(image, field.getMultiplier());
                    }
                }
                return field.formatValue(values);
            }

            @Override
            public String visit(StringIniField field) {
                String value = new String(image.getContent(), field.getOffset(), field.getSize());
                value = value.trim();
                value = this.trimAtZeroSymbol(value);
                return value;
            }

            @NotNull
            private String trimAtZeroSymbol(String value) {
                for (int i = 0; i < value.length(); ++i) {
                    if (value.charAt(i) != '\u0000') continue;
                    value = value.substring(0, i);
                    break;
                }
                return value;
            }
        });
    }

    public static void setValue2(IniField iniField, final ConfigurationImage image, final String name, final String value) {
        iniField.accept(new IniFieldVisitor<Void>(){

            @Override
            public Void visit(ScalarIniField field) {
                Objects.requireNonNull(image, "image for setter");
                Field f = new Field(field.getName(), field.getOffset(), field.getType());
                ByteBuffer wrapped = image.getByteBuffer(field.getOffset(), field.getType().getStorageSize());
                ConfigurationImage.setScalarValue(wrapped, field.getType(), value, f.getBitOffset(), field.getMultiplier(), field.getSerializationOffset());
                return null;
            }

            @Override
            public Void visit(EnumIniField field) {
                String v = value;
                int ordinal = field.getEnums().indexOf(v);
                if (ordinal == -1) {
                    throw new IllegalArgumentException(name + ": Enum name not found " + v);
                }
                image.setBitValue(field, ordinal);
                return null;
            }

            @Override
            public Void visit(ArrayIniField field) {
                Objects.requireNonNull(image, "image array setter");
                String[][] values = field.getValues(value);
                for (int rowIndex = 0; rowIndex < values.length; ++rowIndex) {
                    String[] row = values[rowIndex];
                    for (int colIndex = 0; colIndex < row.length; ++colIndex) {
                        ByteBuffer wrapped = image.getByteBuffer(field.getOffset(rowIndex, colIndex), field.getType().getStorageSize());
                        ConfigurationImage.setScalarValue(wrapped, field.getType(), values[rowIndex][colIndex], -1, field.getMultiplier(), 0.0);
                    }
                }
                return null;
            }

            @Override
            public Void visit(StringIniField field) {
                for (int i = 0; i < value.length(); ++i) {
                    image.getContent()[field.getOffset() + i] = (byte)value.charAt(i);
                }
                return null;
            }
        });
    }
}

