/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContextHelpModel {
    private final String referenceName;
    private final String title;
    private final List<String> textLines;
    private final String webHelp;

    public ContextHelpModel(String referenceName, String title, List<String> textLines, String webHelp) {
        this.referenceName = referenceName;
        this.title = title;
        this.textLines = Collections.unmodifiableList(new ArrayList<String>(textLines));
        this.webHelp = webHelp;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getTextLines() {
        return this.textLines;
    }

    public String getWebHelp() {
        return this.webHelp;
    }

    public String toString() {
        return "ContextHelpModel{referenceName='" + this.referenceName + '\'' + ", title='" + this.title + '\'' + ", textLines=" + this.textLines.size() + ", webHelp='" + this.webHelp + '\'' + '}';
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<div class='context-help'>");
        html.append("<h2>").append(this.title).append("</h2>");
        html.append("<p>").append(String.join((CharSequence)"<br>", this.textLines)).append("</p>");
        if (this.webHelp != null) {
            html.append("<a href='").append(this.webHelp).append("'>Read more</a>");
        }
        html.append("</div>");
        return html.toString();
    }
}

