/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.PanelModel;
import java.util.ArrayList;
import java.util.List;

public class DialogModel {
    private final String key;
    private final String uiName;
    private final List<Field> fields;
    private final List<Command> commandsOfCurrentDialog;
    private final List<PanelModel> panels;
    private final String topicHelp;

    public DialogModel(String key, String uiName, List<Field> fields, List<Command> commandsOfCurrentDialog) {
        this(key, uiName, fields, commandsOfCurrentDialog, new ArrayList<PanelModel>(), null);
    }

    public DialogModel(String key, String uiName, List<Field> fields, List<Command> commandsOfCurrentDialog, String topicHelp) {
        this(key, uiName, fields, commandsOfCurrentDialog, new ArrayList<PanelModel>(), topicHelp);
    }

    public DialogModel(String key, String uiName, List<Field> fields, List<Command> commandsOfCurrentDialog, List<PanelModel> panels, String topicHelp) {
        this.key = key;
        this.uiName = uiName;
        this.fields = new ArrayList<Field>(fields);
        this.commandsOfCurrentDialog = new ArrayList<Command>(commandsOfCurrentDialog);
        this.panels = new ArrayList<PanelModel>(panels);
        this.topicHelp = topicHelp;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<PanelModel> getPanels() {
        return this.panels;
    }

    public String getKey() {
        return this.key;
    }

    public String getUiName() {
        return this.uiName;
    }

    public String getTopicHelp() {
        return this.topicHelp;
    }

    public String toString() {
        return "DialogModel{key='" + this.key + '\'' + ", uiName='" + this.uiName + '\'' + ", fields=" + this.fields.size() + ", panels=" + this.panels.size() + ", topicHelp='" + this.topicHelp + '\'' + '}';
    }

    public static class Command {
        private final String uiName;
        private final String command;

        public Command(String uiName, String command) {
            this.uiName = uiName;
            this.command = command;
        }

        public String getUiName() {
            return this.uiName;
        }

        public String getCommand() {
            return this.command;
        }
    }

    public static class Field {
        private final String key;
        private final String uiName;

        public Field(String key, String uiName) {
            this.key = key;
            this.uiName = uiName;
        }

        public String getKey() {
            return this.key;
        }

        public String getUiName() {
            return this.uiName;
        }

        public String toString() {
            return "Field{key='" + this.key + '\'' + ", uiName='" + this.uiName + '\'' + '}';
        }
    }
}

