/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.devexperts.logging.Logging;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.jetbrains.annotations.Nullable;

public class ExpressionEvaluator {
    private static final Logging log = Logging.getLogging(ExpressionEvaluator.class);

    @Nullable
    public static Double tryEvaluate(String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            return null;
        }
        String cleaned = expression.trim().replaceAll("^\\{\\s*", "").replaceAll("\\s*\\}$", "").trim();
        if (ExpressionEvaluator.containsVariableOrFunction(cleaned)) {
            return null;
        }
        try {
            Expression e = new ExpressionBuilder(cleaned).build();
            return e.evaluate();
        }
        catch (Exception e) {
            log.debug("Failed to evaluate expression: " + expression + " - " + e.getMessage());
            return null;
        }
    }

    private static boolean containsVariableOrFunction(String expression) {
        if (expression.matches(".*(stringValue|bitStringValue|getValue)\\s*\\(.*")) {
            return true;
        }
        String withoutFunctions = expression.replaceAll("\\b(sin|cos|tan|asin|acos|atan|sinh|cosh|tanh|abs|log|log10|log2|sqrt|cbrt|ceil|floor|exp)\\b", "");
        return withoutFunctions.matches(".*[a-zA-Z_].*");
    }

    public static boolean looksLikeExpression(String s) {
        if (s == null || s.trim().isEmpty()) {
            return false;
        }
        if (s.contains("{") || s.contains("}")) {
            return true;
        }
        if (s.matches(".*[+*/()].*")) {
            return true;
        }
        return s.contains("-") && !s.matches("^-?\\d+(\\.\\d+)?$");
    }
}

