/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.IniValue;

public class GaugeModel {
    private final String name;
    private final String channel;
    private final IniValue title;
    private final IniValue units;
    private final IniValue lowValue;
    private final IniValue highValue;
    private final IniValue lowDangerValue;
    private final IniValue lowWarningValue;
    private final IniValue highWarningValue;
    private final IniValue highDangerValue;
    private final IniValue valueDecimalPlaces;
    private final IniValue labelDecimalPlaces;

    public GaugeModel(String name, String channel, IniValue title, IniValue units, IniValue lowValue, IniValue highValue, IniValue lowDangerValue, IniValue lowWarningValue, IniValue highWarningValue, IniValue highDangerValue, IniValue valueDecimalPlaces, IniValue labelDecimalPlaces) {
        this.name = name;
        this.channel = channel;
        this.title = title;
        this.units = units;
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.lowDangerValue = lowDangerValue;
        this.lowWarningValue = lowWarningValue;
        this.highWarningValue = highWarningValue;
        this.highDangerValue = highDangerValue;
        this.valueDecimalPlaces = valueDecimalPlaces;
        this.labelDecimalPlaces = labelDecimalPlaces;
    }

    public String getName() {
        return this.name;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getTitle() {
        return this.title.getRawString();
    }

    public IniValue getTitleValue() {
        return this.title;
    }

    public String getUnits() {
        return this.units.getRawString();
    }

    public IniValue getUnitsValue() {
        return this.units;
    }

    public double getLowValue() {
        return this.lowValue.getNumericValue();
    }

    public IniValue getLowValueValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue.getNumericValue();
    }

    public IniValue getHighValueValue() {
        return this.highValue;
    }

    public double getLowDangerValue() {
        return this.lowDangerValue.getNumericValue();
    }

    public IniValue getLowDangerValueValue() {
        return this.lowDangerValue;
    }

    public double getLowWarningValue() {
        return this.lowWarningValue.getNumericValue();
    }

    public IniValue getLowWarningValueValue() {
        return this.lowWarningValue;
    }

    public double getHighWarningValue() {
        return this.highWarningValue.getNumericValue();
    }

    public IniValue getHighWarningValueValue() {
        return this.highWarningValue;
    }

    public double getHighDangerValue() {
        return this.highDangerValue.getNumericValue();
    }

    public IniValue getHighDangerValueValue() {
        return this.highDangerValue;
    }

    public int getValueDecimalPlaces() {
        return (int)this.valueDecimalPlaces.getNumericValue();
    }

    public IniValue getValueDecimalPlacesValue() {
        return this.valueDecimalPlaces;
    }

    public int getLabelDecimalPlaces() {
        return (int)this.labelDecimalPlaces.getNumericValue();
    }

    public IniValue getLabelDecimalPlacesValue() {
        return this.labelDecimalPlaces;
    }

    public boolean needsOutputChannelEvaluation() {
        return this.title.isExpression() || this.units.isExpression() || this.lowValue.isExpression() || this.highValue.isExpression() || this.lowDangerValue.isExpression() || this.lowWarningValue.isExpression() || this.highWarningValue.isExpression() || this.highDangerValue.isExpression() || this.valueDecimalPlaces.isExpression() || this.labelDecimalPlaces.isExpression();
    }
}

