/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.MandatoryLineMissing;
import com.opensr5.ini.RawIniFile;
import java.util.ArrayList;
import java.util.List;

public class IniFileMetaInfoImpl
implements IniFileMetaInfo {
    private final int nPages;
    private final String signature;
    private final List<String> pageReadCommands;
    private final List<Integer> pageSizes = new ArrayList<Integer>();
    private final int ochBlockSize;

    public IniFileMetaInfoImpl(RawIniFile file) {
        try {
            this.nPages = file.getSimpleIntegerProperty("nPages", 1);
            this.ochBlockSize = file.getSimpleIntegerProperty("ochBlockSize");
            this.signature = file.getValues("signature").get(0);
            List<String> individualPageSizes = file.getValues("pageSize");
            if (individualPageSizes.size() != this.nPages) {
                throw new IllegalStateException("Unexpected individual sizes: " + individualPageSizes);
            }
            for (String value : individualPageSizes) {
                int size = Integer.parseInt(value);
                this.pageSizes.add(size);
            }
            this.pageReadCommands = file.getValues("pageReadCommand");
        }
        catch (MandatoryLineMissing e) {
            throw new RuntimeException("While reading " + file.msg, e);
        }
    }

    @Override
    public int getnPages() {
        return this.nPages;
    }

    @Override
    public int getOchBlockSize() {
        return this.ochBlockSize;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getPageReadCommand(int pageIndex) {
        return this.pageReadCommands.get(pageIndex);
    }

    @Override
    public int getPageSize(int pageIndex) {
        return this.pageSizes.get(pageIndex);
    }
}

