/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.ExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniValue {
    private final Type type;
    private final double numericValue;
    private final String stringValue;

    private IniValue(Type type, double numericValue, String stringValue) {
        this.type = type;
        this.numericValue = numericValue;
        this.stringValue = stringValue;
    }

    public static IniValue ofNumeric(double value) {
        return new IniValue(Type.NUMERIC, value, null);
    }

    public static IniValue ofString(@NotNull String value) {
        return new IniValue(Type.STRING, 0.0, value);
    }

    public static IniValue ofExpression(@NotNull String expression) {
        return new IniValue(Type.EXPRESSION, 0.0, expression);
    }

    public static IniValue parseString(@NotNull String s) {
        if (ExpressionEvaluator.looksLikeExpression(s)) {
            return IniValue.ofExpression(s);
        }
        return IniValue.ofString(s);
    }

    public static IniValue parseNumeric(@NotNull String s) {
        Double evaluated = ExpressionEvaluator.tryEvaluate(s);
        if (evaluated != null) {
            return IniValue.ofNumeric(evaluated);
        }
        if (ExpressionEvaluator.looksLikeExpression(s)) {
            return IniValue.ofExpression(s);
        }
        try {
            double value = Double.parseDouble(s);
            return IniValue.ofNumeric(value);
        }
        catch (NumberFormatException e) {
            return IniValue.ofExpression(s);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isExpression() {
        return this.type == Type.EXPRESSION;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isNumeric() {
        return this.type == Type.NUMERIC;
    }

    public double getNumericValue() {
        return this.numericValue;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    public String getRawString() {
        switch (this.type) {
            case NUMERIC: {
                return String.valueOf(this.numericValue);
            }
            case STRING: 
            case EXPRESSION: {
                return this.stringValue;
            }
        }
        return "";
    }

    public String toString() {
        switch (this.type) {
            case NUMERIC: {
                return "Numeric{" + this.numericValue + "}";
            }
            case STRING: {
                return "String{" + this.stringValue + "}";
            }
            case EXPRESSION: {
                return "Expression{" + this.stringValue + "}";
            }
        }
        return "Unknown{}";
    }

    public static enum Type {
        NUMERIC,
        STRING,
        EXPRESSION;

    }
}

