/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.DataBuffer;
import java.util.TreeMap;

public class TimeBasedBuffer
implements DataBuffer {
    private final TreeMap<Long, Double> values = new TreeMap();
    private final long duration;

    public TimeBasedBuffer(long duration) {
        this.duration = duration;
    }

    private synchronized void truncate() {
        long now = this.currentTimeMillis();
        this.values.headMap(now - this.duration).clear();
    }

    @Override
    public synchronized void clear() {
        this.values.clear();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized void add(double value) {
        this.values.put(this.currentTimeMillis(), value);
    }

    public synchronized int getSize() {
        this.truncate();
        return this.values.size();
    }

    @Override
    public synchronized double[] getValues() {
        this.truncate();
        double[] result = new double[this.values.size()];
        int i = 0;
        for (Double v : this.values.values()) {
            result[i++] = v;
        }
        return result;
    }
}

