/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.composite;

public class CompositeEvent {
    private final long timestamp;
    private final boolean primaryTrigger;
    private final boolean secondaryTrigger;
    private final boolean trg;
    private final boolean sync;
    private static final int numCoils = 6;
    private final boolean[] coils = new boolean[6];
    private static final int numInjectors = 6;
    private final boolean[] injectors = new boolean[6];

    public CompositeEvent(long timestamp, boolean primaryTrigger, boolean secondaryTrigger, boolean trg, boolean sync, boolean coil, boolean injector) {
        int i;
        this.timestamp = timestamp;
        this.primaryTrigger = primaryTrigger;
        this.secondaryTrigger = secondaryTrigger;
        this.trg = trg;
        this.sync = sync;
        this.coils[0] = coil;
        for (i = 1; i < 6; ++i) {
            this.coils[i] = false;
        }
        this.injectors[0] = injector;
        for (i = 1; i < 6; ++i) {
            this.injectors[i] = false;
        }
    }

    public CompositeEvent(long timestamp, boolean primaryTrigger, boolean secondaryTrigger, boolean trg, boolean sync, boolean[] coils, boolean[] injectors) {
        this.timestamp = timestamp;
        this.primaryTrigger = primaryTrigger;
        this.secondaryTrigger = secondaryTrigger;
        this.trg = trg;
        this.sync = sync;
        System.arraycopy(coils, 0, this.coils, 0, 6);
        System.arraycopy(injectors, 0, this.injectors, 0, 6);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int isPrimaryTriggerAsInt() {
        return this.primaryTrigger ? 1 : 0;
    }

    public int isSecondaryTriggerAsInt() {
        return this.secondaryTrigger ? 1 : 0;
    }

    public int isSyncAsInt() {
        return this.sync ? 1 : 0;
    }

    public int isTrgAsInt() {
        return this.trg ? 1 : 0;
    }

    public int isCoil() {
        return this.isCoil(0);
    }

    public int isCoil(int idx) {
        return this.coils[idx] ? 1 : 0;
    }

    public int isInjector() {
        return this.isInjector(0);
    }

    public int isInjector(int idx) {
        return this.injectors[idx] ? 1 : 0;
    }
}

