/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config;

import com.rusefi.core.Pair;

public class FieldCommandResponse {
    private static final String BIT_VALUE_PREFIX = "bit @";
    private static final String INT_VALUE_PREFIX = "int @";
    private static final String FLOAT_VALUE_PREFIX = "float @";

    public static Pair<Integer, ?> parseResponse(String message) {
        try {
            int atPosition = message.indexOf(" @");
            if (atPosition == -1) {
                return null;
            }
            String firstToken = message.substring(0, atPosition);
            if (firstToken.equals("int") || firstToken.equals("byte") || firstToken.equals("short")) {
                String[] a = (message = message.substring(atPosition + " @".length())).split(" is ");
                if (a.length != 2) {
                    return null;
                }
                int index = Integer.parseInt(a[0]);
                int value = Integer.parseInt(a[1]);
                return new Pair<Integer, Integer>(index, value);
            }
            if (FieldCommandResponse.isFloatValueMessage(message)) {
                String[] a = (message = message.substring(FLOAT_VALUE_PREFIX.length())).split(" is ");
                if (a.length != 2) {
                    return null;
                }
                int index = Integer.parseInt(a[0]);
                double value = Double.parseDouble(a[1]);
                return new Pair<Integer, Double>(index, value);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isIntValueMessage(String message) {
        return message.startsWith(INT_VALUE_PREFIX) || message.startsWith("byte") || message.startsWith("short");
    }

    public static boolean isBitValueMessage(String message) {
        return message.startsWith(BIT_VALUE_PREFIX);
    }

    public static boolean isFloatValueMessage(String message) {
        return message.startsWith(FLOAT_VALUE_PREFIX);
    }
}

