/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.io;

import java.util.Objects;

public class BundleInfo {
    public static final String DEVELOPMENT = "development";
    static final BundleInfo UNKNOWN = new BundleInfo("unknown", null, "unknown");
    private final String branchName;
    private final String nextBranchName;
    private final String target;

    public BundleInfo(String branchName, String nextBranchName, String target) {
        this.branchName = Objects.requireNonNull(branchName, "branchName");
        this.nextBranchName = nextBranchName;
        this.target = Objects.requireNonNull(target, "target");
    }

    public static boolean isUndefined(BundleInfo bundleInfo) {
        return bundleInfo == UNKNOWN;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getNextBranchName() {
        return this.nextBranchName;
    }

    public boolean isMaster() {
        return DEVELOPMENT.equals(this.branchName);
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        String nextBranchString = this.nextBranchName != null && !this.nextBranchName.isEmpty() ? "nextBranchName='" + this.nextBranchName + '\'' : "";
        return "BundleInfo{branchName='" + this.branchName + '\'' + nextBranchString + ", target='" + this.target + '\'' + '}';
    }

    public String getUiLabel() {
        return this.target + "." + this.branchName;
    }
}

