/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.functional_tests;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.autotest.ControllerConnectorState;
import com.rusefi.core.ISensorCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.engine_type_e;
import com.rusefi.functional_tests.TestHelper;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;
import com.rusefi.waves.EngineReport;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class EcuTestHelper {
    public static final Function<String, Object> FAIL = errorCode -> {
        if (errorCode != null) {
            throw new IllegalStateException("Failed " + errorCode);
        }
        return null;
    };
    private static final Logging log = Logging.getLogging(EcuTestHelper.class);
    public static int currentEngineType;
    public final CommandQueue commandQueue;
    @NotNull
    private final LinkManager linkManager;

    public EcuTestHelper(LinkManager linkManager) {
        this.commandQueue = linkManager.getCommandQueue();
        this.linkManager = linkManager;
    }

    public static void assertRpmDoesNotJump(int rpm, int settleTime, int testDuration, Function<String, Object> callback, CommandQueue commandQueue) {
        IoUtil.changeRpm(commandQueue, rpm);
        IoUtil.sleepSeconds(settleTime);
        AtomicReference result = new AtomicReference();
        long start = System.currentTimeMillis();
        ISensorCentral.ListenerToken listener = SensorCentral.getInstance().addListener(Sensor.RPMValue, actualRpm -> {
            if (!EngineReport.isCloseEnough(rpm, actualRpm)) {
                long seconds = (System.currentTimeMillis() - start) / 1000L;
                result.set("Got " + actualRpm + " while trying to stay at " + rpm + " after " + seconds + " seconds");
            }
        });
        IoUtil.sleepSeconds(testDuration);
        callback.apply((String)result.get());
        listener.remove();
    }

    @NotNull
    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public static void assertSomewhatClose(double expected, double actual) {
        EcuTestHelper.assertSomewhatClose("", expected, actual);
    }

    public static void assertSomewhatClose(String msg, double expected, double actual) {
        EcuTestHelper.assertSomewhatClose(msg, expected, actual, 0.05);
    }

    public static void assertSomewhatClose(String msg, double expected, double actual, double ratio) {
        if (!EngineReport.isCloseEnough(expected, actual, ratio)) {
            throw new IllegalStateException(msg + " Expected " + expected + " but got " + actual);
        }
    }

    @NotNull
    public static EcuTestHelper createInstance(boolean allowHardwareTriggerInput) {
        EcuTestHelper ecu = new EcuTestHelper(ControllerConnectorState.getLinkManager());
        if (allowHardwareTriggerInput) {
            ecu.sendCommand(IoUtil.getEnableCommand("trigger_hw_input"));
        } else {
            ecu.sendCommand(IoUtil.getDisableCommand("trigger_hw_input"));
        }
        ecu.enableFunctionalMode();
        return ecu;
    }

    public void sendCommand(String command) {
        this.sendCommand(command, 20000);
    }

    public void sendCommand(String command, int timeoutMs) {
        TestHelper.INSTANCE.assertNotFatal();
        IoUtil.sendBlockingCommand(command, timeoutMs, this.commandQueue);
    }

    public void enableFunctionalMode() {
        this.sendCommand(IoUtil.getEnableCommand("test_mode"));
    }

    public void changeRpm(int rpm) {
        IoUtil.changeRpm(this.commandQueue, rpm);
    }

    public void setEngineType(engine_type_e engine_type_e2) {
        int type = engine_type_e2.ordinal();
        log.info("AUTOTEST setEngineType " + type);
        currentEngineType = type;
        this.sendCommand(IoUtil.getDisableCommand("self_stimulation"));
        this.sendCommand(IoUtil.getDisableCommand("injection"));
        this.sendCommand(IoUtil.getDisableCommand("ignition"));
        this.sendCommand(IoUtil.getDisableCommand("pwm"));
        IoUtil.sleepSeconds(2);
        this.sendCommand("set engine_type " + type, 60000);
        IoUtil.sleepSeconds(1);
        this.sendCommand(IoUtil.getEnableCommand("pwm"));
        this.sendCommand(IoUtil.getEnableCommand("self_stimulation"));
    }
}

