/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ini.reader;

import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.EnumIniField;
import com.rusefi.config.FieldType;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class EnumIniReaderHelper {
    private static final String STARTS_WITH_NUMBERS_OPTIONAL_SPACES_AND_EQUALS = "^\\d+\\s*=.*";
    private static final Pattern IS_KEY_VALUE_SYNTAX = Pattern.compile("^\\d+\\s*=.*");

    private EnumIniReaderHelper() {
    }

    public static EnumIniField parse(LinkedList<String> list, RawIniFile.Line line, Map<String, List<String>> defines) {
        String name = list.get(0);
        FieldType type = FieldType.parseTs(list.get(2));
        int offset = Integer.parseInt(list.get(3));
        String bitRange = list.get(4);
        ParseBitRange parseBitRange = new ParseBitRange().invoke(bitRange);
        int bitPosition = parseBitRange.getBitPosition();
        int bitSize0 = parseBitRange.getBitSize0();
        EnumIniField.EnumKeyValueMap enums = EnumIniField.EnumKeyValueMap.valueOf(line.getRawText(), defines);
        return new EnumIniField(name, offset, type, enums, bitPosition, bitSize0);
    }

    public static boolean isKeyValueSyntax(String rawText) {
        String interestingPart = EnumIniReaderHelper.getEnumValuesSection(rawText);
        return IS_KEY_VALUE_SYNTAX.matcher(interestingPart).matches();
    }

    @NotNull
    public static String getEnumValuesSection(String rawText) {
        int interestingIndex = EnumIniReaderHelper.ordinalIndexOf(rawText, ",", 4);
        return rawText.substring(interestingIndex + 1).trim();
    }

    private static int ordinalIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }

    public static class ParseBitRange {
        private int bitPosition;
        private int bitSize0;

        public int getBitPosition() {
            return this.bitPosition;
        }

        public int getBitSize0() {
            return this.bitSize0;
        }

        public ParseBitRange invoke(String bitRange) {
            String[] bitPositions = (bitRange = bitRange.replaceAll("[\\]\\[:]", " ").trim()).split(" ");
            if (bitPositions.length != 2) {
                throw new IllegalStateException("Bit position " + bitRange);
            }
            this.bitPosition = Integer.parseInt(bitPositions[0]);
            this.bitSize0 = Integer.parseInt(bitPositions[1]) - this.bitPosition;
            return this;
        }
    }
}

