/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ini.reader;

import com.devexperts.logging.Logging;
import com.opensr5.ini.ContextHelpModel;
import com.opensr5.ini.DialogModel;
import com.opensr5.ini.GaugeCategoryModel;
import com.opensr5.ini.GaugeModel;
import com.opensr5.ini.ImmutableIniFileModel;
import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniValue;
import com.opensr5.ini.PanelModel;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.TableModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.ini.reader.EnumIniReaderHelper;
import com.rusefi.ini.reader.TableBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniFileReader {
    private static final Logging log = Logging.getLogging(IniFileReader.class);
    public static final String RUSEFI_INI_PREFIX = "rusefi";
    public static final String RUSEFI_INI_SUFFIX = ".ini";
    public static final String INI_FILE_PATH = System.getProperty("ini_file_path", "..");
    private static final String SECTION_PAGE = "page";
    private static final String FIELD_TYPE_SCALAR = "scalar";
    public static final String FIELD_TYPE_STRING = "string";
    private static final String FIELD_TYPE_ARRAY = "array";
    private static final String FIELD_TYPE_BITS = "bits";
    private final Map<String, List<String>> defines = new TreeMap<String, List<String>>();
    private String dialogId;
    private String dialogUiName;
    private String dialogTopicHelp;
    private final Map<String, DialogModel> dialogs = new TreeMap<String, DialogModel>();
    private final List<DialogModel.Field> fieldsOfCurrentDialog = new ArrayList<DialogModel.Field>();
    private final List<DialogModel.Command> commandsOfCurrentDialog = new ArrayList<DialogModel.Command>();
    private final List<PanelModel> panelsOfCurrentDialog = new ArrayList<PanelModel>();
    private final Map<String, IniField> allIniFields = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IniField> secondaryIniFields = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IniField> allOutputChannels = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    public final Map<String, DialogModel.Field> fieldsInUiOrder = new LinkedHashMap<String, DialogModel.Field>();
    private final Map<String, String> tooltips = new TreeMap<String, String>();
    private final Map<String, String> protocolMeta = new TreeMap<String, String>();
    private boolean isConstantsSection;
    private boolean isOutputChannelsSection;
    private final IniFileMetaInfo metaInfo;
    private final String iniFilePath;
    private boolean isGaugeConfigurationsSection = false;
    private String currentGaugeCategory = null;
    private final Map<String, GaugeCategoryModel> gaugeCategories = new LinkedHashMap<String, GaugeCategoryModel>();
    private final List<GaugeModel> currentCategoryGauges = new ArrayList<GaugeModel>();
    private final Map<String, GaugeModel> allGauges = new TreeMap<String, GaugeModel>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> topicHelpMap = new TreeMap<String, String>();
    private final Map<String, ContextHelpModel> contextHelp = new LinkedHashMap<String, ContextHelpModel>();
    private String currentHelpReferenceName;
    private String currentHelpTitle;
    private final List<String> currentHelpTextLines = new ArrayList<String>();
    private String currentHelpWebHelp;
    private boolean isTableEditorSection = false;
    private final Map<String, TableModel> allTables = new TreeMap<String, TableModel>(String.CASE_INSENSITIVE_ORDER);
    private final TableBuilder tableBuilder = new TableBuilder();
    private boolean isInSettingContextHelp = false;
    private boolean isInsidePageDefinition;
    private int blockingFactor;
    private static final Integer blockingFactorOverride = Integer.getInteger("blockingFactorOverride");
    private int currentPageIndex;

    public IniFileModel getIniFileModel() {
        this.finishContextHelp();
        return new ImmutableIniFileModel(this.metaInfo.getSignature(), this.getBlockingFactor(), this.defines, this.allIniFields, this.secondaryIniFields, this.allOutputChannels, this.protocolMeta, this.getMetaInfo(), this.getIniFilePath(), this.tooltips, this.fieldsInUiOrder, this.dialogs, this.gaugeCategories, this.allGauges, this.topicHelpMap, this.contextHelp, this.allTables);
    }

    IniFileReader(@Nullable IniFileMetaInfo metaInfo, String iniFilePath) {
        this.metaInfo = metaInfo;
        this.iniFilePath = iniFilePath;
    }

    public int getBlockingFactor() {
        if (blockingFactorOverride != null) {
            return blockingFactorOverride;
        }
        return this.blockingFactor;
    }

    public IniFileMetaInfo getMetaInfo() {
        return Objects.requireNonNull(this.metaInfo, "metaInfo");
    }

    public String getIniFilePath() {
        return Objects.requireNonNull(this.iniFilePath, "iniFilePath");
    }

    void finishDialog() {
        if (this.fieldsOfCurrentDialog.isEmpty() && this.commandsOfCurrentDialog.isEmpty() && this.panelsOfCurrentDialog.isEmpty()) {
            return;
        }
        if (this.dialogUiName == null) {
            this.dialogUiName = this.dialogId;
        }
        this.dialogs.put(this.dialogId, new DialogModel(this.dialogId, this.dialogUiName, this.fieldsOfCurrentDialog, this.commandsOfCurrentDialog, this.panelsOfCurrentDialog, this.dialogTopicHelp));
        this.dialogId = null;
        this.dialogTopicHelp = null;
        this.fieldsOfCurrentDialog.clear();
        this.commandsOfCurrentDialog.clear();
        this.panelsOfCurrentDialog.clear();
    }

    void handleLine(RawIniFile.Line line) {
        String rawText = line.getRawText();
        try {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(line.getTokens()));
            if (!list.isEmpty() && list.get(0).equals("#define")) {
                this.defines.put(list.get(1), list.subList(2, list.size()));
                return;
            }
            if (!list.isEmpty() && list.get(0).equals(SECTION_PAGE)) {
                if (list.size() >= 2) {
                    this.currentPageIndex = Integer.parseInt(list.get(1));
                }
                this.isInsidePageDefinition = true;
                return;
            }
            if (this.isInSettingContextHelp) {
                if (rawText.contains("SettingContextHelpEnd")) {
                    this.finishContextHelp();
                    this.isInSettingContextHelp = false;
                }
                this.handleSettingContextHelpLine(list);
                return;
            }
            if (RawIniFile.Line.isCommentLine(rawText)) {
                return;
            }
            if (RawIniFile.Line.isPreprocessorDirective(rawText)) {
                return;
            }
            this.trim(list);
            if (list.isEmpty()) {
                return;
            }
            String first = list.getFirst();
            if (first.equalsIgnoreCase("blockingFactor")) {
                this.blockingFactor = Integer.parseInt(list.get(1));
            }
            if (first.startsWith("[") && first.endsWith("]")) {
                log.info("Section " + first);
                boolean wasGaugeSection = this.isGaugeConfigurationsSection;
                boolean wasTableSection = this.isTableEditorSection;
                if (first.contains("[SettingContextHelp]")) {
                    this.isInsidePageDefinition = false;
                    this.isInSettingContextHelp = true;
                }
                this.isConstantsSection = first.equals("[Constants]");
                this.isOutputChannelsSection = first.equals("[OutputChannels]");
                this.isGaugeConfigurationsSection = first.equalsIgnoreCase("[GaugeConfigurations]");
                this.isTableEditorSection = first.equalsIgnoreCase("[TableEditor]");
                if (wasGaugeSection && !this.isGaugeConfigurationsSection) {
                    this.finishGaugeCategory();
                }
                if (wasTableSection && !this.isTableEditorSection) {
                    this.finishTable();
                }
            }
            if (this.isConstantsSection) {
                if (this.isInsidePageDefinition) {
                    if (list.size() > 1) {
                        this.handleConstantFieldDefinition(list, line);
                    }
                    return;
                }
                if (list.size() > 1) {
                    this.protocolMeta.put(list.get(0), list.get(1));
                }
            } else {
                if (this.isOutputChannelsSection) {
                    this.handleOutputChannelDefinition(list);
                    return;
                }
                if (this.isGaugeConfigurationsSection) {
                    this.handleGaugeConfiguration(list);
                    return;
                }
                if (this.isTableEditorSection) {
                    this.tableBuilder.handleLine(list, this::addField, this::finishTable);
                    return;
                }
            }
            switch (first) {
                case "field": {
                    this.handleField(list);
                    break;
                }
                case "commandButton": {
                    this.handleCommand(list);
                    break;
                }
                case "slider": {
                    this.handleSlider(list);
                    break;
                }
                case "dialog": {
                    this.handleDialog(list);
                    break;
                }
                case "panel": {
                    this.handlePanel(list);
                    break;
                }
                case "topicHelp": {
                    this.handleTopicHelp(list);
                    break;
                }
                case "help": {
                    this.handleHelpEntry(list);
                    break;
                }
                case "text": {
                    this.handleHelpText(list);
                    break;
                }
                case "webHelp": {
                    this.handleHelpWebHelp(list);
                    break;
                }
                case "xBins": 
                case "yBins": {
                    this.handleBins(list);
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to handle [" + rawText + "]: " + e, e);
        }
    }

    private void handleOutputChannelDefinition(LinkedList<String> list) {
        String channelType;
        if (list.size() < 2) {
            return;
        }
        String name = list.get(0);
        switch (channelType = list.get(1)) {
            case "scalar": {
                String scalarType = list.get(2);
                int offset = Integer.parseInt(list.get(3));
                this.allOutputChannels.put(name, new ScalarIniField(name, offset, scalarType, null, 1.0, "0", 0.0));
            }
        }
    }

    private void addField(String key) {
        DialogModel.Field field = new DialogModel.Field(key, key);
        this.fieldsInUiOrder.put(key, field);
    }

    private void handleBins(LinkedList<String> list) {
        if (list.size() >= 2) {
            list.removeFirst();
            String binsConstant = list.removeFirst();
            this.addField(binsConstant);
        }
    }

    private void handleConstantFieldDefinition(LinkedList<String> list, RawIniFile.Line line) {
        switch (list.get(1)) {
            case "scalar": {
                this.registerField(ScalarIniField.parse(list));
                break;
            }
            case "string": {
                this.registerField(StringIniField.parse(list));
                break;
            }
            case "array": {
                this.registerField(ArrayIniField.parse(list));
                break;
            }
            case "bits": {
                this.registerField(EnumIniReaderHelper.parse(list, line, this.defines));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + list);
            }
        }
    }

    private void registerField(IniField field) {
        if (this.currentPageIndex != 1) {
            log.info("Skipping field from secondary page: " + field);
            this.secondaryIniFields.put(field.getName(), field);
            return;
        }
        if (this.allIniFields.containsKey(field.getName())) {
            return;
        }
        this.allIniFields.put(field.getName(), field);
    }

    private void handleSlider(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Slider label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void handleCommand(LinkedList<String> list) {
        list.removeFirst();
        String uiName = list.removeFirst();
        String command = list.removeFirst();
        this.commandsOfCurrentDialog.add(new DialogModel.Command(uiName, command));
    }

    private void handleField(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Field label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void registerUiField(String key, String uiFieldName) {
        DialogModel.Field field = new DialogModel.Field(key, uiFieldName);
        if (key != null) {
            this.fieldsOfCurrentDialog.add(field);
            if (!this.fieldsInUiOrder.containsKey(key) || this.fieldsInUiOrder.get(key).getUiName() == key) {
                this.fieldsInUiOrder.put(key, field);
            }
        }
    }

    private void handleDialog(LinkedList<String> list) {
        this.finishDialog();
        list.removeFirst();
        String keyword = list.removeFirst();
        String name = list.isEmpty() ? null : list.removeFirst();
        this.dialogId = keyword;
        this.dialogUiName = name;
        log.debug("IniFileModel: Dialog key=" + keyword + ": name=[" + name + "]");
    }

    private void handlePanel(LinkedList<String> list) {
        String visibleExpression;
        list.removeFirst();
        String panelName = list.isEmpty() ? null : list.removeFirst();
        String placement = list.isEmpty() ? null : list.removeFirst();
        String enableExpression = list.isEmpty() ? null : list.removeFirst();
        String string = visibleExpression = list.isEmpty() ? null : list.removeFirst();
        if (panelName != null) {
            PanelModel panel = new PanelModel(panelName, placement, enableExpression, visibleExpression);
            this.panelsOfCurrentDialog.add(panel);
            log.debug("IniFileModel: Panel name=[" + panelName + "] placement=[" + placement + "]");
        }
    }

    private void handleTopicHelp(LinkedList<String> list) {
        list.removeFirst();
        if (!list.isEmpty()) {
            String topicHelpValue;
            this.dialogTopicHelp = topicHelpValue = list.removeFirst();
            if (this.dialogId != null) {
                this.topicHelpMap.put(this.dialogId, topicHelpValue);
                log.debug("IniFileModel: topicHelp=[" + topicHelpValue + "] for dialog=[" + this.dialogId + "]");
            }
        }
    }

    private void trim(LinkedList<String> list) {
        while (!list.isEmpty() && list.getFirst().isEmpty()) {
            list.removeFirst();
        }
    }

    private void handleGaugeConfiguration(LinkedList<String> list) {
        if (list.size() < 2) {
            return;
        }
        String gaugeName = list.get(0);
        if (gaugeName.equalsIgnoreCase("gaugeCategory")) {
            this.finishGaugeCategory();
            this.currentGaugeCategory = list.get(1);
            return;
        }
        if (list.size() < 6) {
            log.warn("Skipping incomplete gauge definition: " + gaugeName + " (expected at least 6 fields, got " + list.size() + ")");
            return;
        }
        try {
            GaugeModel gauge = this.getGaugeModel(list, gaugeName);
            this.currentCategoryGauges.add(gauge);
            this.allGauges.put(gaugeName, gauge);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse gauge: " + gaugeName + ": " + e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("Failed to parse gauge: " + gaugeName + ": " + e.getMessage());
        }
    }

    @NotNull
    private GaugeModel getGaugeModel(LinkedList<String> list, String gaugeName) {
        String channel = list.get(1);
        IniValue title = IniValue.parseString(list.get(2));
        IniValue units = IniValue.parseString(list.get(3));
        IniValue lowValue = IniValue.parseNumeric(list.get(4));
        IniValue highValue = IniValue.parseNumeric(list.get(5));
        IniValue lowDangerValue = list.size() > 6 ? IniValue.parseNumeric(list.get(6)) : lowValue;
        IniValue lowWarningValue = list.size() > 7 ? IniValue.parseNumeric(list.get(7)) : lowValue;
        IniValue highWarningValue = list.size() > 8 ? IniValue.parseNumeric(list.get(8)) : highValue;
        IniValue highDangerValue = list.size() > 9 ? IniValue.parseNumeric(list.get(9)) : highValue;
        IniValue valueDecimalPlaces = list.size() > 10 ? IniValue.parseNumeric(list.get(10)) : IniValue.ofNumeric(0.0);
        IniValue labelDecimalPlaces = list.size() > 11 ? IniValue.parseNumeric(list.get(11)) : IniValue.ofNumeric(0.0);
        return new GaugeModel(gaugeName, channel, title, units, lowValue, highValue, lowDangerValue, lowWarningValue, highWarningValue, highDangerValue, valueDecimalPlaces, labelDecimalPlaces);
    }

    void finishGaugeCategory() {
        if (this.currentGaugeCategory != null && !this.currentCategoryGauges.isEmpty()) {
            this.gaugeCategories.put(this.currentGaugeCategory, new GaugeCategoryModel(this.currentGaugeCategory, new ArrayList<GaugeModel>(this.currentCategoryGauges)));
            this.currentCategoryGauges.clear();
        }
        this.currentGaugeCategory = null;
    }

    private void handleSettingContextHelpLine(LinkedList<String> list) {
        if (list.isEmpty()) {
            return;
        }
        String first = list.get(0);
        if (first.startsWith(";")) {
            return;
        }
        if (first.equals("help") && list.size() >= 3) {
            this.finishContextHelp();
            this.currentHelpReferenceName = list.get(1);
            this.currentHelpTitle = list.get(2);
            return;
        }
        if (first.equals("text") && list.size() >= 2 && this.currentHelpReferenceName != null) {
            this.currentHelpTextLines.add(list.get(1));
            return;
        }
        if (first.equals("webHelp") && list.size() >= 2 && this.currentHelpReferenceName != null) {
            this.currentHelpWebHelp = list.get(1);
            return;
        }
        if (list.size() == 2) {
            this.tooltips.put(first, list.get(1));
        }
    }

    void finishContextHelp() {
        if (this.currentHelpReferenceName != null) {
            ContextHelpModel helpModel = new ContextHelpModel(this.currentHelpReferenceName, this.currentHelpTitle, this.currentHelpTextLines, this.currentHelpWebHelp);
            this.contextHelp.put(this.currentHelpReferenceName, helpModel);
            this.currentHelpReferenceName = null;
            this.currentHelpTitle = null;
            this.currentHelpTextLines.clear();
            this.currentHelpWebHelp = null;
        }
    }

    private void handleHelpEntry(LinkedList<String> list) {
        if (list.size() >= 3) {
            this.finishContextHelp();
            this.currentHelpReferenceName = list.get(1);
            this.currentHelpTitle = list.get(2);
        }
    }

    private void handleHelpText(LinkedList<String> list) {
        if (list.size() >= 2 && this.currentHelpReferenceName != null) {
            this.currentHelpTextLines.add(list.get(1));
        }
    }

    private void handleHelpWebHelp(LinkedList<String> list) {
        if (list.size() >= 2 && this.currentHelpReferenceName != null) {
            this.currentHelpWebHelp = list.get(1);
        }
    }

    private double parseDouble(String s) {
        return IniField.parseDouble(s);
    }

    private int parseInt(String s) {
        return (int)IniField.parseDouble(s);
    }

    void finishTable() {
        if (this.tableBuilder.isComplete()) {
            TableModel table = this.tableBuilder.build();
            this.allTables.put(this.tableBuilder.getTableId(), table);
            String tableId = this.tableBuilder.getTableId();
            if (tableId != null && !tableId.isEmpty()) {
                this.allTables.put(tableId, table);
            }
        }
        this.tableBuilder.reset();
    }

    static {
        if (blockingFactorOverride != null) {
            log.info("blockingFactorOverride=" + blockingFactorOverride);
        }
    }
}

