/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ini.reader;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileMetaInfoImpl;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.RawIniFile;
import com.rusefi.ini.reader.IniFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class IniFileReaderUtil {
    private static final Logging log = Logging.getLogging(IniFileReaderUtil.class);

    private IniFileReaderUtil() {
    }

    public static String[] splitTokens(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        boolean inQuote = false;
        boolean hadQuote = false;
        int openedBraceCount = 0;
        StringBuilder sb = new StringBuilder();
        block4: for (char c : str.toCharArray()) {
            if (c == '\"' || IniFileReaderUtil.isTokenSeparator(c) && !inQuote && openedBraceCount == 0) {
                if (c == '\"') {
                    boolean bl = inQuote = !inQuote;
                    if (!inQuote) {
                        hadQuote = true;
                    }
                }
                if (!inQuote && sb.length() > 0) {
                    strings.add(sb.toString());
                    sb.delete(0, sb.length());
                    hadQuote = false;
                    continue;
                }
                if (!hadQuote) continue;
                strings.add("");
                hadQuote = false;
                continue;
            }
            sb.append(c);
            switch (c) {
                case '{': {
                    ++openedBraceCount;
                    continue block4;
                }
                case '}': {
                    if (0 < openedBraceCount) {
                        --openedBraceCount;
                        continue block4;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected closing brace: %s", str));
                }
            }
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static boolean isTokenSeparator(int c) {
        return c == 32 || c == 9 || c == 61 || c == 44;
    }

    public static RawIniFile read(InputStream in) {
        return IniFileReaderUtil.read(in, "unknown");
    }

    public static RawIniFile read(InputStream in, String msg) {
        ArrayList<RawIniFile.Line> lines = new ArrayList<RawIniFile.Line>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                lines.add(new RawIniFile.Line(line));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new RawIniFile(lines, msg);
    }

    public static RawIniFile read(File input) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(input);
        return IniFileReaderUtil.read(in, input.getAbsolutePath());
    }

    @NotNull
    public static IniFileModel readIniFile(RawIniFile content, String iniFilePath, IniFileMetaInfo metaInfo) {
        IniFileReader result = new IniFileReader(metaInfo, iniFilePath);
        for (RawIniFile.Line line : content.getLines()) {
            result.handleLine(line);
        }
        result.finishDialog();
        result.finishGaugeCategory();
        result.finishTable();
        return result.getIniFileModel();
    }

    @NotNull
    public static IniFileModel readIniFile(String fileName) throws FileNotFoundException {
        Objects.requireNonNull(fileName, "fileName");
        log.info("Reading " + fileName);
        File input = new File(fileName);
        RawIniFile content = IniFileReaderUtil.read(input);
        return IniFileReaderUtil.readIniFile(content, fileName, new IniFileMetaInfoImpl(content));
    }
}

