/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ini.reader;

import com.devexperts.logging.Logging;
import com.opensr5.ini.TableModel;
import java.util.LinkedList;
import java.util.function.Consumer;

class TableBuilder {
    private static final Logging log = Logging.getLogging(TableBuilder.class);
    private String tableId;
    private String map3dId;
    private String title;
    private String topicHelp;
    private String xLabel;
    private String yLabel;
    private String xBinsConstant;
    private String xBinsChannel;
    private boolean xBinsReadOnly;
    private String yBinsConstant;
    private String yBinsChannel;
    private boolean yBinsReadOnly;
    private String zBinsConstant;
    private String upLabel;
    private String downLabel;
    private Double gridHeight;
    private String gridOrient;

    TableBuilder() {
    }

    void setTableDefinition(String tableId, String map3dId, String title) {
        this.tableId = tableId;
        this.map3dId = map3dId;
        this.title = title;
    }

    void setTopicHelp(String topicHelp) {
        this.topicHelp = topicHelp;
    }

    void setXyLabels(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    void setXBins(String constant, String channel, boolean readOnly) {
        this.xBinsConstant = constant;
        this.xBinsChannel = channel;
        this.xBinsReadOnly = readOnly;
    }

    void setYBins(String constant, String channel, boolean readOnly) {
        this.yBinsConstant = constant;
        this.yBinsChannel = channel;
        this.yBinsReadOnly = readOnly;
    }

    void setZBins(String constant) {
        this.zBinsConstant = constant;
    }

    void setUpDownLabel(String upLabel, String downLabel) {
        this.upLabel = upLabel;
        this.downLabel = downLabel;
    }

    void setGridHeight(Double gridHeight) {
        this.gridHeight = gridHeight;
    }

    void setGridOrient(String gridOrient) {
        this.gridOrient = gridOrient;
    }

    boolean isComplete() {
        return this.tableId != null && this.xBinsConstant != null && this.yBinsConstant != null && this.zBinsConstant != null;
    }

    boolean isActive() {
        return this.tableId != null;
    }

    String getTableId() {
        return this.tableId;
    }

    String getMap3dId() {
        return this.map3dId;
    }

    String getXBinsConstant() {
        return this.xBinsConstant;
    }

    String getYBinsConstant() {
        return this.yBinsConstant;
    }

    String getZBinsConstant() {
        return this.zBinsConstant;
    }

    TableModel build() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot build incomplete table: " + this.tableId);
        }
        return new TableModel(this.tableId, this.map3dId, this.title, this.topicHelp, this.xLabel, this.yLabel, this.xBinsConstant, this.xBinsChannel, this.xBinsReadOnly, this.yBinsConstant, this.yBinsChannel, this.yBinsReadOnly, this.zBinsConstant, this.upLabel, this.downLabel, this.gridHeight, this.gridOrient);
    }

    void reset() {
        this.tableId = null;
        this.map3dId = null;
        this.title = null;
        this.topicHelp = null;
        this.xLabel = null;
        this.yLabel = null;
        this.xBinsConstant = null;
        this.xBinsChannel = null;
        this.xBinsReadOnly = false;
        this.yBinsConstant = null;
        this.yBinsChannel = null;
        this.yBinsReadOnly = false;
        this.zBinsConstant = null;
        this.upLabel = null;
        this.downLabel = null;
        this.gridHeight = null;
        this.gridOrient = null;
    }

    boolean handleLine(LinkedList<String> list, Consumer<String> fieldRegistrar, Runnable finishCurrentTable) {
        String keyword;
        if (list.size() < 2) {
            return false;
        }
        switch (keyword = list.get(0)) {
            case "table": {
                finishCurrentTable.run();
                this.parseTableDefinition(list);
                return true;
            }
            case "topicHelp": {
                if (!this.isActive()) break;
                this.setTopicHelp(list.get(1));
                break;
            }
            case "xyLabels": {
                if (!this.isActive() || list.size() < 3) break;
                this.setXyLabels(list.get(1), list.get(2));
                break;
            }
            case "xBins": {
                if (!this.isActive() || list.size() < 2) break;
                String constant = list.get(1);
                String channel = list.size() >= 3 ? list.get(2) : null;
                boolean readOnly = list.contains("readOnly");
                this.setXBins(constant, channel, readOnly);
                fieldRegistrar.accept(constant);
                break;
            }
            case "yBins": {
                if (!this.isActive() || list.size() < 2) break;
                String constant = list.get(1);
                String channel = list.size() >= 3 ? list.get(2) : null;
                boolean readOnly = list.contains("readOnly");
                this.setYBins(constant, channel, readOnly);
                fieldRegistrar.accept(constant);
                break;
            }
            case "zBins": {
                if (!this.isActive() || list.size() < 2) break;
                String constant = list.get(1);
                this.setZBins(constant);
                fieldRegistrar.accept(constant);
                break;
            }
            case "upDownLabel": {
                if (!this.isActive() || list.size() < 3) break;
                this.setUpDownLabel(list.get(1), list.get(2));
                break;
            }
            case "gridHeight": {
                if (!this.isActive() || list.size() < 2) break;
                try {
                    this.setGridHeight(Double.parseDouble(list.get(1)));
                }
                catch (NumberFormatException e) {
                    log.warn("Failed to parse gridHeight: " + list.get(1));
                }
                break;
            }
            case "gridOrient": {
                if (!this.isActive() || list.size() < 2) break;
                this.setGridOrient(String.join((CharSequence)",", list.subList(1, list.size())));
            }
        }
        return false;
    }

    private void parseTableDefinition(LinkedList<String> list) {
        if (list.size() < 4) {
            log.warn("Incomplete table definition, expected at least 4 fields");
            return;
        }
        list.removeFirst();
        String tableId = list.removeFirst().trim();
        String map3dId = list.removeFirst().trim();
        String title = list.removeFirst().trim();
        this.setTableDefinition(tableId, map3dId, title);
    }
}

