/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class CommunicationThreadFactory
extends NamedThreadFactory {
    private static final Logging log = Logging.getLogging(CommunicationThreadFactory.class);
    private final AtomicReference<Thread> communicationThread = new AtomicReference();

    CommunicationThreadFactory() {
        super("ECU Communication Executor", true);
    }

    public boolean isInCommunicationThread() {
        return this.communicationThread.get() == Thread.currentThread();
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread newCommunicationThread = super.newThread(r);
        Thread prevCommunicationThread = this.communicationThread.getAndSet(newCommunicationThread);
        if (prevCommunicationThread != null) {
            log.warn("Multiple communication threads.");
        }
        return newCommunicationThread;
    }
}

