/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.jobs;

import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.ExportTuneJobContext;
import com.rusefi.maintenance.jobs.JobHelper;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.util.Optional;
import javax.swing.JComponent;

public class ExportTuneJob
extends AsyncJobWithContext<ExportTuneJobContext> {
    private final ConnectivityContext connectivityContext;

    public ExportTuneJob(PortResult port, String fileName, ConnectivityContext connectivityContext) {
        super("Save Tune", new ExportTuneJobContext(port, fileName));
        this.connectivityContext = connectivityContext;
    }

    public static void exportTuneFromDevice(PortResult port, JComponent parent, ConnectivityContext connectivityContext, String tuneFileName, SingleAsyncJobExecutor singleAsyncJobExecutor) {
        singleAsyncJobExecutor.startJob(new ExportTuneJob(port, tuneFileName, connectivityContext), parent);
    }

    @Override
    public void doJob(UpdateOperationCallbacks callbacks, Runnable onJobFinished) {
        JobHelper.doJob(() -> {
            Optional<CalibrationsInfo> calibrationsInfo = CalibrationsHelper.readCurrentCalibrations(((ExportTuneJobContext)this.context).getPort().port, callbacks, this.connectivityContext);
            if (calibrationsInfo.isPresent()) {
                if (CalibrationsHelper.backUpCalibrationsInfo(calibrationsInfo.get(), ((ExportTuneJobContext)this.context).getFileName(), callbacks)) {
                    callbacks.done();
                } else {
                    callbacks.error();
                }
            } else {
                callbacks.error();
            }
        }, onJobFinished);
    }
}

