/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Map;
import java.util.Optional;

public enum BattLagCorrExtensionMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME = "injector_battLagCorrBins";
    public static final String INJECTOR_BATT_LAG_CORR_FIELD_NAME = "injector_battLagCorr";
    public static final String INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME = "injector_battLagCorrBattBins";
    public static final String INJECTOR_BATT_LAG_CORR_PRESS_BINS_FIELD_NAME = "injector_battLagCorrPressBins";
    public static final String INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME = "injector_battLagCorrTable";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        IniFileModel prevIniFile = context.getPrevIniFile();
        Optional<IniField> prevInjectorBattLagCorrBinsField = prevIniFile.findIniField(INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME);
        if (!prevInjectorBattLagCorrBinsField.isPresent()) {
            return;
        }
        Optional<IniField> prevInjectorBattLagCorrField = prevIniFile.findIniField(INJECTOR_BATT_LAG_CORR_FIELD_NAME);
        if (!prevInjectorBattLagCorrField.isPresent()) {
            return;
        }
        if (prevIniFile.findIniField(INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME).isPresent()) {
            context.logWarn(String.format("Prev ini file contains both `%s` and `%s` ini fields", INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME, INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME));
            return;
        }
        if (prevIniFile.findIniField(INJECTOR_BATT_LAG_CORR_PRESS_BINS_FIELD_NAME).isPresent()) {
            context.logWarn(String.format("Prev ini file contains both `%s` and `%s` ini fields", INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME, INJECTOR_BATT_LAG_CORR_PRESS_BINS_FIELD_NAME));
            return;
        }
        if (prevIniFile.findIniField(INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME).isPresent()) {
            context.logWarn(String.format("Prev ini file contains both `%s` and `%s` ini fields", INJECTOR_BATT_LAG_CORR_FIELD_NAME, INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME));
            return;
        }
        IniFileModel updatedIniFile = context.getUpdatedIniFile();
        Optional<IniField> updatedInjectorBattLagCorrBattBinsField = updatedIniFile.findIniField(INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME);
        if (!updatedInjectorBattLagCorrBattBinsField.isPresent()) {
            return;
        }
        Optional<IniField> updatedInjectorBattLagCorrPressBinsField = updatedIniFile.findIniField(INJECTOR_BATT_LAG_CORR_PRESS_BINS_FIELD_NAME);
        if (!updatedInjectorBattLagCorrPressBinsField.isPresent()) {
            return;
        }
        Optional<IniField> updatedInjectorBattLagCorrTableField = updatedIniFile.findIniField(INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME);
        if (!updatedInjectorBattLagCorrTableField.isPresent()) {
            return;
        }
        if (updatedIniFile.findIniField(INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME).isPresent()) {
            context.logWarn(String.format("Updated ini file contains both `%s` and `%s` ini fields", INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME, INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME));
            return;
        }
        if (updatedIniFile.findIniField(INJECTOR_BATT_LAG_CORR_FIELD_NAME).isPresent()) {
            context.logWarn(String.format("Updated ini file contains both `%s` and `%s` ini fields", INJECTOR_BATT_LAG_CORR_FIELD_NAME, INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME));
            return;
        }
        Optional<ArrayIniField> injectorBattLagCorrBinsArrayIniField = BattLagCorrExtensionMigrator.getValidatedInjectorBattLagCorrBinsArrayIniField(prevInjectorBattLagCorrBinsField.get(), context.getCallbacks());
        if (!injectorBattLagCorrBinsArrayIniField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> injectorBattLagCorrArrayIniField = BattLagCorrExtensionMigrator.getValidatedInjectorBattLagCorrArrayIniField(prevInjectorBattLagCorrField.get(), context.getCallbacks());
        if (!injectorBattLagCorrArrayIniField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> injectorBattLagCorrBattBinsArrayIniField = BattLagCorrExtensionMigrator.getValidatedInjectorBattLagCorrBattBinsArrayIniField(updatedInjectorBattLagCorrBattBinsField.get(), context.getCallbacks());
        if (!injectorBattLagCorrBattBinsArrayIniField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> injectorBattLagCorrPressBinsArrayIniField = BattLagCorrExtensionMigrator.getValidatedInjectorBattLagCorrPressBinsArrayIniField(updatedInjectorBattLagCorrPressBinsField.get(), context.getCallbacks());
        if (!injectorBattLagCorrPressBinsArrayIniField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> injectorBattLagCorrTableArrayIniField = BattLagCorrExtensionMigrator.getValidatedInjectorBattLagCorrTableArrayIniField(updatedInjectorBattLagCorrTableField.get(), context.getCallbacks());
        if (!injectorBattLagCorrTableArrayIniField.isPresent()) {
            return;
        }
        Map<String, Constant> prevTune = context.getPrevTune().getConstantsAsMap();
        Constant prevInjectorBattLagCorrBins = prevTune.get(INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME);
        if (prevInjectorBattLagCorrBins == null) {
            return;
        }
        Constant prevInjectorBattLagCorr = prevTune.get(INJECTOR_BATT_LAG_CORR_FIELD_NAME);
        if (prevInjectorBattLagCorr == null) {
            return;
        }
        Map<String, Constant> updatedTune = context.getUpdatedTune().getConstantsAsMap();
        Constant updatedInjectorBattLagCorrTable = updatedTune.get(INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME);
        if (updatedInjectorBattLagCorrTable == null || !updatedInjectorBattLagCorrTable.getValue().equals(prevInjectorBattLagCorr.getValue())) {
            context.addMigration(INJECTOR_BATT_LAG_CORR_BINS_FIELD_NAME, INJECTOR_BATT_LAG_CORR_BATT_BINS_FIELD_NAME, BattLagCorrExtensionMigrator.generateConstant(injectorBattLagCorrBattBinsArrayIniField.get(), prevInjectorBattLagCorrBins.getValue()));
        }
        context.addMigration(INJECTOR_BATT_LAG_CORR_FIELD_NAME, INJECTOR_BATT_LAG_CORR_TABLE_FIELD_NAME, BattLagCorrExtensionMigrator.generateConstant(injectorBattLagCorrTableArrayIniField.get(), this.migrateInjectorBattLagCorrValue(injectorBattLagCorrArrayIniField.get(), injectorBattLagCorrTableArrayIniField.get(), prevInjectorBattLagCorr.getValue())));
    }

    private static Constant generateConstant(ArrayIniField iniField, String value) {
        return new Constant(iniField.getName(), iniField.getUnits(), value, iniField.getDigits(), String.valueOf(iniField.getRows()), String.valueOf(iniField.getCols()));
    }

    private String migrateInjectorBattLagCorrValue(ArrayIniField prevInjectorBattLagCorrField, ArrayIniField updatedInjectorBattLagCorrTableField, String prevInjectorBattLagCorrValue) {
        String[][] prevValues = prevInjectorBattLagCorrField.getValues(prevInjectorBattLagCorrValue);
        String[][] migratedValues = new String[2][prevValues.length];
        for (int i = 0; i < prevValues.length; ++i) {
            migratedValues[0][i] = prevValues[i][0];
            migratedValues[1][i] = prevValues[i][0];
        }
        return updatedInjectorBattLagCorrTableField.formatValue(migratedValues);
    }

    private static Optional<ArrayIniField> getValidatedInjectorBattLagCorrBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBins` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.FLOAT) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBins` ini-field is expected to be FLOAT instead of %s", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 8) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBins` ini-field is expected to contain 8 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBins` ini-field is expected to contain 1 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static Optional<ArrayIniField> getValidatedInjectorBattLagCorrArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorr` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.FLOAT) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorr` ini-field is expected to be FLOAT instead of %s", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 8) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorr` ini-field is expected to contain 8 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorr` ini-field is expected to contain 1 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static Optional<ArrayIniField> getValidatedInjectorBattLagCorrBattBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBattBins` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.INT16) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBattBins` ini-field is expected to be INT16 instead of %s", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 8) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBattBins` ini-field is expected to contain 8 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrBattBins` ini-field is expected to contain 1 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static Optional<ArrayIniField> getValidatedInjectorBattLagCorrPressBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrPressBins` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.INT) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrPressBins` ini-field is expected to be INT16 instead of %s", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 2) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrPressBins` ini-field is expected to contain 2 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrPressBins` ini-field is expected to contain 1 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static Optional<ArrayIniField> getValidatedInjectorBattLagCorrTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrTable` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.INT16) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrTable` ini-field is expected to be INT16 instead of %s", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 2) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrTable` ini-field is expected to contain 2 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 8) {
            callbacks.logLine(String.format("WARNING! `injector_battLagCorrTable` ini-field is expected to contain 8 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }
}

