/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum BoostLoadBinsMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String BOOST_LOAD_BINS_FIELD_NAME = "boostLoadBins";
    public static final String BOOST_OPEN_LOOP_LOAD_BINS_FIELD_NAME = "boostOpenLoopLoadBins";
    public static final String BOOST_CLOSED_LOOP_LOAD_BINS_FIELD_NAME = "boostClosedLoopLoadBins";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        IniFileModel prevIniFile = context.getPrevIniFile();
        Optional<IniField> prevBoostLoadBinsIniField = prevIniFile.findIniField(BOOST_LOAD_BINS_FIELD_NAME);
        if (!prevBoostLoadBinsIniField.isPresent()) {
            return;
        }
        if (!(prevBoostLoadBinsIniField.get() instanceof ArrayIniField)) {
            context.logWarn(String.format("`%s` .ini-field is expected to be instance of `ArrayIniField`, but actually is instance of`%s`.", BOOST_LOAD_BINS_FIELD_NAME, prevBoostLoadBinsIniField.get().getClass().getSimpleName()));
            return;
        }
        ArrayIniField prevBoostLoadBinsArrayIniField = (ArrayIniField)prevBoostLoadBinsIniField.get();
        Constant prevBoostLoadBinsConstant = context.getPrevTune().getConstantsAsMap().get(BOOST_LOAD_BINS_FIELD_NAME);
        if (null == prevBoostLoadBinsConstant) {
            return;
        }
        String prevBoostLoadBinsValue = prevBoostLoadBinsConstant.getValue();
        if (null == prevBoostLoadBinsValue) {
            return;
        }
        this.migrateBoostLoadBinsToNewBoostLoadBinsIfNeeded(context, prevBoostLoadBinsArrayIniField, prevBoostLoadBinsConstant, BOOST_OPEN_LOOP_LOAD_BINS_FIELD_NAME);
        this.migrateBoostLoadBinsToNewBoostLoadBinsIfNeeded(context, prevBoostLoadBinsArrayIniField, prevBoostLoadBinsConstant, BOOST_CLOSED_LOOP_LOAD_BINS_FIELD_NAME);
        IniFileModel updatedIniFile = context.getUpdatedIniFile();
        Optional<IniField> updatedBoostLoadBinsIniField = updatedIniFile.findIniField(BOOST_LOAD_BINS_FIELD_NAME);
        if (!updatedBoostLoadBinsIniField.isPresent()) {
            context.addMigration(BOOST_LOAD_BINS_FIELD_NAME, null);
        }
    }

    private void migrateBoostLoadBinsToNewBoostLoadBinsIfNeeded(TuneMigrationContext context, ArrayIniField prevBoostLoadBinsArrayIniField, Constant prevBoostLoadBinsConstant, String newBoostLoadBinsFieldName) {
        IniFileModel prevIniFile = context.getPrevIniFile();
        Optional<IniField> prevNewBoostLoadBinsField = prevIniFile.findIniField(newBoostLoadBinsFieldName);
        if (prevNewBoostLoadBinsField.isPresent()) {
            return;
        }
        IniFileModel updatedIniFile = context.getUpdatedIniFile();
        Optional<IniField> updatedNewBoostLoadBinsIniField = updatedIniFile.findIniField(newBoostLoadBinsFieldName);
        if (!updatedNewBoostLoadBinsIniField.isPresent()) {
            return;
        }
        if (!(updatedNewBoostLoadBinsIniField.get() instanceof ArrayIniField)) {
            context.logWarn(String.format("`%s` .ini-field is expected to be instance of `ArrayIniField`, but actually is instance of`%s`.", updatedNewBoostLoadBinsIniField, updatedNewBoostLoadBinsIniField.get().getClass().getSimpleName()));
            return;
        }
        ArrayIniField updatedNewBoostLoadBinsArrayIniField = (ArrayIniField)updatedNewBoostLoadBinsIniField.get();
        if (updatedNewBoostLoadBinsArrayIniField.getType() != prevBoostLoadBinsArrayIniField.getType()) {
            context.logWarn(String.format("Type mismatch: %s and %s", prevBoostLoadBinsArrayIniField, updatedNewBoostLoadBinsArrayIniField));
            return;
        }
        if (updatedNewBoostLoadBinsArrayIniField.getCols() != prevBoostLoadBinsArrayIniField.getCols()) {
            context.logWarn(String.format("Cols mismatch: %s and %s", prevBoostLoadBinsArrayIniField, updatedNewBoostLoadBinsArrayIniField));
            return;
        }
        if (updatedNewBoostLoadBinsArrayIniField.getRows() != prevBoostLoadBinsArrayIniField.getRows()) {
            context.logWarn(String.format("Rows mismatch: %s and %s", prevBoostLoadBinsArrayIniField, updatedNewBoostLoadBinsArrayIniField));
            return;
        }
        if (!updatedNewBoostLoadBinsArrayIniField.getDigits().equals(prevBoostLoadBinsArrayIniField.getDigits())) {
            context.logWarn(String.format("Digits mismatch: %s and %s", prevBoostLoadBinsArrayIniField, updatedNewBoostLoadBinsArrayIniField));
            return;
        }
        context.addMigration(newBoostLoadBinsFieldName, prevBoostLoadBinsConstant);
    }
}

