/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.IntDigitField;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum DigitsIniFieldMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Logging log;
    private static final IntDigitField[] fieldsToMigrate;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        for (IntDigitField field : fieldsToMigrate) {
            Optional<IniField> prevBooleanIniField = context.getPrevIniFile().findIniField(field.getFieldName());
            Optional<IniField> updatedBooleanIniField = context.getUpdatedIniFile().findIniField(field.getFieldName());
            if (!prevBooleanIniField.isPresent() || !updatedBooleanIniField.isPresent()) continue;
            Constant prevBooleanConst = context.getPrevTune().getConstantsAsMap().get(field.getFieldName());
            Constant updatedBooleanConst = context.getUpdatedTune().getConstantsAsMap().get(field.getFieldName());
            String prevBooleanValue = prevBooleanConst.getValue();
            if (null == prevBooleanConst || null == updatedBooleanConst) continue;
            Optional<Boolean> shouldMigrate = field.shouldMigrateField(prevBooleanConst.getDigits(), updatedBooleanConst.getDigits());
            if (shouldMigrate.isPresent()) {
                if (!shouldMigrate.get().booleanValue()) continue;
                Constant migratedBooleanConst = prevBooleanConst.cloneWithValue(String.valueOf(field.migrateField(prevBooleanValue)));
                context.addMigration(field.getFieldName(), migratedBooleanConst);
                continue;
            }
            log.warn(String.format("Invalid scalar migration on oldTune `%s` :(", field.getFieldName()));
        }
    }

    static {
        log = Logging.getLogging(DigitsIniFieldMigrator.class);
        fieldsToMigrate = new IntDigitField[]{new IntDigitField("ppsExpAverageAlpha", v -> v * 100.0, "3", "1"), new IntDigitField("tpsMin", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tpsMax", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps1SecondaryMin", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps1SecondaryMax", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps2Min", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps2Max", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps2SecondaryMin", v -> v * 0.0048828125, "0", "2"), new IntDigitField("tps2SecondaryMax", v -> v * 0.0048828125, "0", "2")};
    }
}

