/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Locale;
import java.util.Optional;

public enum IdleCurveMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String IDLE_CURVE_NAME = "cltIdleCorr";
    public static final String IDLE_TABLE_NAME = "cltIdleCorrTable";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        ArrayIniField updatedTableField;
        int columnSize;
        Optional<IniField> prevIdleCurve = context.getPrevIniFile().findIniField(IDLE_CURVE_NAME);
        Optional<IniField> updatedIdleTable = context.getUpdatedIniFile().findIniField(IDLE_TABLE_NAME);
        if (!prevIdleCurve.isPresent() || !updatedIdleTable.isPresent()) {
            return;
        }
        Constant prevIdleCurveData = context.getPrevTune().getConstantsAsMap().get(IDLE_CURVE_NAME);
        ArrayIniField prevCurveField = (ArrayIniField)prevIdleCurve.get();
        int prevCurveRowSize = prevCurveField.getRows();
        if (prevCurveRowSize == (columnSize = (updatedTableField = (ArrayIniField)updatedIdleTable.get()).getCols())) {
            String[][] prevValues = prevCurveField.getValues(prevIdleCurveData.getValue());
            int colCount = updatedTableField.getCols();
            String[][] migratedTableValues = new String[updatedTableField.getRows()][colCount];
            for (int row = 0; row < updatedTableField.getRows(); ++row) {
                for (int col = 0; col < colCount; ++col) {
                    migratedTableValues[row][col] = prevValues[col][0];
                }
            }
            context.addMigration(IDLE_CURVE_NAME, IDLE_TABLE_NAME, IniFieldMigrationUtils.generateConstant(updatedTableField, updatedTableField.formatValue(migratedTableValues)));
        } else if (prevCurveRowSize < columnSize) {
            String[][] prevValues = prevCurveField.getValues(prevIdleCurveData.getValue());
            String[][] migratedTableValues = IdleCurveMigrator.upsampleCurveToTable(prevValues, prevCurveRowSize, columnSize, updatedTableField.getRows(), prevCurveField.getDigits());
            context.addMigration(IDLE_CURVE_NAME, IDLE_TABLE_NAME, IniFieldMigrationUtils.generateConstant(updatedTableField, updatedTableField.formatValue(migratedTableValues)));
        } else {
            String[][] prevValues = prevCurveField.getValues(prevIdleCurveData.getValue());
            String[][] migratedTableValues = IdleCurveMigrator.downsampleCurveToTable(prevValues, prevCurveRowSize, columnSize, updatedTableField.getRows());
            context.addMigration(IDLE_CURVE_NAME, IDLE_TABLE_NAME, IniFieldMigrationUtils.generateConstant(updatedTableField, updatedTableField.formatValue(migratedTableValues)));
        }
    }

    public static String[][] downsampleCurveToTable(String[][] prevValues, int curveRowSize, int columnSize, int rowSize) {
        int i;
        int newStartSize = columnSize / 3;
        int newEndSize = columnSize / 3;
        int newMiddleSize = columnSize - newStartSize - newEndSize;
        int middleStartIndex = (curveRowSize - newMiddleSize) / 2;
        String[][] migratedTableValues = new String[rowSize][columnSize];
        int destCol = 0;
        for (i = 0; i < newStartSize; ++i) {
            migratedTableValues[0][destCol++] = prevValues[i][0];
        }
        for (i = 0; i < newMiddleSize; ++i) {
            migratedTableValues[0][destCol++] = prevValues[middleStartIndex + i][0];
        }
        for (i = 0; i < newEndSize; ++i) {
            migratedTableValues[0][destCol++] = prevValues[curveRowSize - newEndSize + i][0];
        }
        for (i = 1; i < rowSize; ++i) {
            migratedTableValues[i] = migratedTableValues[0];
        }
        return migratedTableValues;
    }

    public static String[][] upsampleCurveToTable(String[][] prevValues, int curveRowSize, int columnSize, int rowSize, String digits) {
        int i;
        String[][] migratedTableValues = new String[rowSize][columnSize];
        double[] prevDoubleValues = new double[curveRowSize];
        for (int i2 = 0; i2 < curveRowSize; ++i2) {
            prevDoubleValues[i2] = Double.parseDouble(prevValues[i2][0]);
        }
        double scale = (double)(curveRowSize - 1) / (double)(columnSize - 1);
        for (i = 0; i < columnSize; ++i) {
            double interpolatedValue;
            double position = (double)i * scale;
            int lowerIndex = (int)position;
            int upperIndex = Math.min(lowerIndex + 1, curveRowSize - 1);
            if (lowerIndex == upperIndex) {
                interpolatedValue = prevDoubleValues[lowerIndex];
            } else {
                double fraction = position - (double)lowerIndex;
                interpolatedValue = prevDoubleValues[lowerIndex] * (1.0 - fraction) + prevDoubleValues[upperIndex] * fraction;
            }
            migratedTableValues[0][i] = IdleCurveMigrator.formatArrayValue(interpolatedValue, digits);
        }
        for (i = 1; i < rowSize; ++i) {
            migratedTableValues[i] = migratedTableValues[0];
        }
        return migratedTableValues;
    }

    public static String formatArrayValue(double value, String digits) {
        int numDigits = Integer.parseInt(digits);
        return String.format(Locale.US, "%." + numDigits + "f", value);
    }
}

