/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import com.rusefi.util.LazyFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SdCardFieldsContent {
    public static final String SD_CARD_OUTPUT_FILE_NAME = "console/binary/generated/log_fields_generated.h";
    public static final String BOARD_LOOKUP_H = "#include \"board_lookup.h\"\n";
    private final Map<Optional<String>, List<String>> collectedFieldsMap = new HashMap<Optional<String>, List<String>>();
    public String[] expressions = new String[]{"test->reference"};
    public String conditional;
    public Boolean isPtr = false;
    public String[] names;
    public int structureStartingTsPosition;

    public static void wrapContent(LazyFile output, String content) {
        SdCardFieldsContent.wrapContent(output, content, "");
    }

    public static void wrapContent(LazyFile output, String content, String additionalHeaders) {
        output.write("// generated by " + SdCardFieldsContent.class + "\n");
        output.write("#pragma once\n");
        output.write(BOARD_LOOKUP_H);
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            output.write(additionalHeaders);
        }
        output.write("static LOG_FIELD_CONSTNESS_SPECIFIER_STORAGE MLG::Entries::Field fields[] = {\n\t{packedTime, GAUGE_NAME_TIME, \"sec\", 0},\n");
        output.write(content);
        output.write("};\n");
    }

    public void handleEndStruct(ReaderState state, ConfigStructure structure) throws IOException {
        if (state.isStackEmpty()) {
            for (int i = 0; i < this.expressions.length; ++i) {
                String namePrefix = SdCardFieldsContent.getNamePrefix(i, this.names);
                String expression = this.expressions[i];
                this.appendFields(state, structure, namePrefix, expression);
            }
        }
    }

    public static String getNamePrefix(int i, String[] names) {
        return names == null || names.length <= 1 ? "" : names[i];
    }

    private void appendFields(ReaderState state, ConfigStructure structure, final String namePrefix, final String expression) {
        PerFieldWithStructuresIterator.Strategy strategy = new PerFieldWithStructuresIterator.Strategy(){

            @Override
            public String process(ReaderState state, ConfigField configField, String prefix, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator) {
                String line = SdCardFieldsContent.this.processOutput(configField, prefix, currentPosition, perFieldWithStructuresIterator, namePrefix, expression);
                Optional<String> key = Optional.ofNullable(SdCardFieldsContent.this.conditional);
                SdCardFieldsContent.this.collectedFieldsMap.computeIfAbsent(key, k -> new ArrayList()).add(line);
                return line;
            }

            @Override
            public String getArrayElementName(ConfigField cf) {
                return cf.getOriginalArrayName();
            }
        };
        PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(state, structure.getTsFields(), "", strategy, ".");
        this.structureStartingTsPosition = iterator.loop(this.structureStartingTsPosition);
    }

    private String processOutput(ConfigField configField, String prefix, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator, String namePrefix, String expression) {
        if (configField.isUnusedField()) {
            return "";
        }
        String name = configField.getOriginalArrayName();
        return SdCardFieldsContent.getLine(configField, prefix, namePrefix, prefix + name, expression, this.isPtr, this.conditional, currentPosition, perFieldWithStructuresIterator, this.structureStartingTsPosition);
    }

    private static String getLine(ConfigField configField, String prefix, String outputNamePrefix, String name, String expression, Boolean isPtr, String conditional, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator, int structureStartingTsPosition) {
        String humanName = DataLogConsumer.getHumanGaugeName(outputNamePrefix, prefix, configField, "");
        String categoryStr = configField.getCategory();
        categoryStr = categoryStr == null ? "" : ", " + categoryStr;
        boolean isEnum = configField.getTypeName().contains("_e");
        if (isEnum) {
            return "";
        }
        if (configField.isBit()) {
            int offsetWithinCurrentStructure = currentPosition - structureStartingTsPosition;
            if (offsetWithinCurrentStructure < 0) {
                throw new IllegalStateException(humanName + " seems broken: " + currentPosition + " vs " + structureStartingTsPosition);
            }
            return "\t{" + (isPtr != false ? "*" : "") + expression + ", " + offsetWithinCurrentStructure + ", " + perFieldWithStructuresIterator.bitState.get() + ", " + humanName + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + categoryStr + "},\n";
        }
        return "\t{" + expression + (isPtr != false ? "->" : ".") + name + ", " + humanName + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + ", " + configField.getDigits() + categoryStr + "},\n";
    }

    public void processCollectedFieldsBlocks(StringBuilder body) {
        Comparator<Optional> optCmp = Comparator.comparing(o -> o.orElse(null), Comparator.nullsFirst(String::compareTo));
        this.collectedFieldsMap.entrySet().stream().sorted(Map.Entry.comparingByKey(optCmp)).forEach(e -> {
            String conditionalKey = ((Optional)e.getKey()).orElse(null);
            List block = (List)e.getValue();
            if (conditionalKey != null) {
                body.append("#if ").append(conditionalKey).append("\n");
            }
            block.forEach(body::append);
            if (conditionalKey != null) {
                body.append("#endif\n");
            }
        });
    }

    public String getBody() {
        StringBuilder body = new StringBuilder();
        this.processCollectedFieldsBlocks(body);
        return body.toString();
    }
}

