/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.stream;

import com.rusefi.composite.CompositeEvent;
import com.rusefi.core.rusEFIVersion;
import com.rusefi.stream.StreamFile;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class TSHighSpeedLog
extends StreamFile {
    private final String fileName;
    private long prevTime = 0L;

    public TSHighSpeedLog(String fileName) {
        this.fileName = fileName;
    }

    private static void writeHeader(Writer writer) throws IOException {
        writer.write("#Firmware: console20260125 firmware " + rusEFIVersion.firmwareVersion.get() + "\n");
        writer.write("PriLevel,SecLevel,Trigger,Sync,Time,ToothTime,coil,inj\nFlag,Flag,Flag,Flag,ms,ms,Flag,Flag\n");
    }

    @Override
    public void append(List<CompositeEvent> events) {
        try {
            if (this.writer == null) {
                this.createFileWriter(this.fileName);
                TSHighSpeedLog.writeHeader(this.writer);
            }
            for (CompositeEvent event : events) {
                this.writer.write(event.isPrimaryTriggerAsInt() + "," + event.isSecondaryTriggerAsInt() + "," + event.isTrgAsInt() + "," + event.isSyncAsInt() + ",");
                long delta = event.getTimestamp() - this.prevTime;
                this.writer.write((double)event.getTimestamp() / 1000.0 + "," + (double)delta / 1000.0);
                this.writer.write("," + event.isCoil() + "," + event.isInjector());
                this.writer.write("\n");
                this.prevTime = event.getTimestamp();
            }
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void writeFooter() throws IOException {
        if (this.writer != null) {
            this.writer.write("MARK 028\n");
        }
    }
}

