/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.stream;

import com.rusefi.composite.CompositeEvent;
import com.rusefi.stream.StreamFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;

public class VcdStreamFile
extends StreamFile {
    private static final String TAG_PRIMARY = "t";
    private static final String TAG_SECONDARY = "s";
    private static final String TAG_TRG = "r";
    private static final String TAG_SYNC = "y";
    private static final String TAG_COIL = "c";
    private static final String TAG_INJ = "i";
    private final String fileName;

    public VcdStreamFile(String fileName) {
        this.fileName = fileName;
    }

    private static void writeHeader(Writer writer, Date date) throws IOException {
        writer.write("$date\n");
        writer.write("\t" + date + "\n");
        writer.write("$end\n$version\n        1.0\n$end\n$timescale\n        1ps\n$end\n$scope module test $end\n$var wire 1 t PRI_TRG $end\n$var wire 1 s SEC_TRG $end\n$var wire 1 r TRG $end\n$var wire 1 y SYNC $end\n$var wire 1 c COIL $end\n$var wire 1 i INJ $end\n$upscope $end\n$enddefinitions $end\n$dumpvars\n");
    }

    public static void appendEvents(List<CompositeEvent> events, Writer writer) throws IOException {
        for (CompositeEvent event : events) {
            writer.write("#" + event.getTimestamp() + "\n");
            writer.write(event.isPrimaryTriggerAsInt() + TAG_PRIMARY + "\n");
            writer.write(event.isSecondaryTriggerAsInt() + TAG_SECONDARY + "\n");
            writer.write(event.isTrgAsInt() + TAG_TRG + "\n");
            writer.write(event.isSyncAsInt() + TAG_SYNC + "\n");
            writer.write(event.isCoil() + TAG_COIL + "\n");
            writer.write(event.isInjector() + TAG_INJ + "\n");
        }
        writer.flush();
    }

    public static void writeVCD(List<CompositeEvent> events, Writer writer, Date date) throws IOException {
        VcdStreamFile.writeHeader(writer, date);
        VcdStreamFile.appendEvents(events, writer);
    }

    public static void writeVCD(List<CompositeEvent> events, FileWriter fileWriter) throws IOException {
        VcdStreamFile.writeVCD(events, fileWriter, new Date());
    }

    @Override
    public void append(List<CompositeEvent> events) {
        try {
            if (this.writer == null) {
                this.createFileWriter(this.fileName);
                VcdStreamFile.writeHeader(this.writer, new Date());
            }
            VcdStreamFile.appendEvents(events, this.writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

