/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.uds;

import com.devexperts.logging.Logging;
import com.rusefi.io.can.SocketCanConnector;
import com.rusefi.uds.CanConnector;
import com.rusefi.uds.M74_9_SeedKeyCalculator;
import com.rusefi.uds.PCanConnector;
import com.rusefi.util.HexBinary;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class M74_9_UdsSandbox {
    public static final byte RND = -95;
    private static final Logging log = Logging.getLogging(M74_9_UdsSandbox.class);
    private static final int UDS_OUT = 2016;
    private static final int OX27 = 39;
    private static final int OX67 = 103;

    public static void main(String[] args) {
        boolean useSocketCan = args.length > 0 && args[0].toLowerCase().contains("socket");
        CanConnector connector = useSocketCan ? SocketCanConnector.create() : PCanConnector.createPCanConnector();
        M74_9_UdsSandbox.startThread(connector);
        connector.send(2016, new byte[]{2, 16, 2, 0, 0, 0, 0, 0});
    }

    private static void startThread(CanConnector connector) {
        Runnable r = () -> {
            while (true) {
                CanConnector.CanPacket packet;
                if ((packet = connector.read()) == null || packet.id() != 2024) {
                    continue;
                }
                byte[] data = packet.payload();
                if (M74_9_UdsSandbox.isProgramAck(data)) {
                    log.info("Program Request ACK");
                    connector.send(2016, new byte[]{3, 39, 1, -95, 0, 0, 0, 0});
                    continue;
                }
                if (M74_9_UdsSandbox.isSeed(data)) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(data, 3, 4);
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    int seed = byteBuffer.getInt();
                    log.info(String.format("SECURITY_ACCESS REQUEST_SEED %x from %s", seed, HexBinary.printByteArray(data)));
                    int key = M74_9_SeedKeyCalculator.Uds_Security_CalcKey(-1303424439, seed, -95);
                    byte[] keyResponse = new byte[]{6, 39, 2, 0, 0, 0, 0, 0};
                    ByteBuffer responseBuffer = ByteBuffer.wrap(keyResponse, 3, 4);
                    responseBuffer.putInt(key);
                    log.info(String.format("SECURITY_ACCESS SEND_KEY %x from %s", key, HexBinary.printByteArray(keyResponse)));
                    connector.send(2016, keyResponse);
                    continue;
                }
                if (M74_9_UdsSandbox.startsWith(data, new byte[]{3, 127, 39, 53})) {
                    log.error("UNHAPPY :(");
                    System.exit(-1);
                    continue;
                }
                if (!M74_9_UdsSandbox.startsWith(data, new byte[]{2, 103, 2})) continue;
                log.error("HAPPILY UNLOCKED :)");
                System.exit(0);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private static boolean isSeed(byte[] data) {
        return M74_9_UdsSandbox.startsWith(data, new byte[]{6, 103, 1});
    }

    private static boolean isProgramAck(byte[] data) {
        return M74_9_UdsSandbox.startsWith(data, new byte[]{6, 80, 2});
    }

    private static boolean startsWith(byte[] data, byte[] bytes) {
        if (data.length < bytes.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (data[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }
}

