/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.maintenance.jobs.ExportTuneJob;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportTuneFileChooser {
    private static final String TUNE_TO_EXPORT_DEFAULT_DIRECTORY_PROPERTY_NAME = "tune_to_export_default_directory";
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final JFileChooser tuneToExportFileChooser = ExportTuneFileChooser.createTuneToExportFileChooser();

    public ExportTuneFileChooser(SingleAsyncJobExecutor singleAsyncJobExecutor) {
        this.singleAsyncJobExecutor = singleAsyncJobExecutor;
    }

    void showFileChooserToExportTuneAction(PortResult port, JComponent parent, ConnectivityContext connectivityContext) {
        int selectedOption = this.tuneToExportFileChooser.showSaveDialog(parent);
        if (selectedOption == 0) {
            File selectedFile = this.tuneToExportFileChooser.getSelectedFile();
            String path = selectedFile.getAbsolutePath();
            if (!path.toLowerCase().endsWith(".msq")) {
                path = path + ".msq";
                selectedFile = new File(path);
            }
            ExportTuneFileChooser.saveTuneToExportDefaultDirectory(selectedFile.getParent());
            String baseName = path.substring(0, path.length() - 4);
            ExportTuneJob.exportTuneFromDevice(port, parent, connectivityContext, baseName, this.singleAsyncJobExecutor);
        }
    }

    private static JFileChooser createTuneToExportFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("Tune files (.msq)", "msq"));
        String currentDirectory = ExportTuneFileChooser.loadTuneToExportDefaultDirectory();
        if (currentDirectory != null && !currentDirectory.isEmpty()) {
            fc.setCurrentDirectory(new File(currentDirectory));
        }
        return fc;
    }

    private static void saveTuneToExportDefaultDirectory(String path) {
        PersistentConfiguration.getConfig().getRoot().setProperty(TUNE_TO_EXPORT_DEFAULT_DIRECTORY_PROPERTY_NAME, path);
        PersistentConfiguration.getConfig().save();
    }

    private static String loadTuneToExportDefaultDirectory() {
        return PersistentConfiguration.getConfig().getRoot().getProperty(TUNE_TO_EXPORT_DEFAULT_DIRECTORY_PROPERTY_NAME, "");
    }
}

