/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.CompatibilityOptional;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.basic.BasicButtonCoordinator;
import com.rusefi.ui.basic.EnableableControl;
import com.rusefi.ui.basic.ExportTuneFileChooser;
import com.rusefi.ui.basic.ImportTuneFileChooser;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImportTuneControl
implements EnableableControl {
    private final JButton importTuneButton = new JButton("Load Tune From File...", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final JButton exportTuneButton = new JButton("Save Tune To File...", AutoupdateUtil.loadIcon("download48.jpg"));
    private final ImportTuneFileChooser importTune;
    private final ExportTuneFileChooser exportTune;
    private final BasicButtonCoordinator basicButtonCoordinator;
    private final ConnectivityContext connectivityContext;
    private final AtomicReference<Optional<PortResult>> ecuPortToUse;

    public ImportTuneControl(SingleAsyncJobExecutor singleAsyncJobExecutor, BasicButtonCoordinator basicButtonCoordinator, ConnectivityContext connectivityContext, AtomicReference<Optional<PortResult>> ecuPortToUse) {
        this.basicButtonCoordinator = basicButtonCoordinator;
        this.connectivityContext = connectivityContext;
        this.ecuPortToUse = ecuPortToUse;
        this.importTuneButton.addActionListener(this::onImportTuneButtonClicked);
        this.exportTuneButton.addActionListener(this::onExportTuneButtonClicked);
        this.importTune = new ImportTuneFileChooser(singleAsyncJobExecutor);
        this.exportTune = new ExportTuneFileChooser(singleAsyncJobExecutor);
    }

    @Override
    public void setEnabled(boolean b) {
        this.importTuneButton.setEnabled(b);
        this.exportTuneButton.setEnabled(b);
    }

    public Component getContent() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.importTuneButton);
        panel.add(this.exportTuneButton);
        return panel;
    }

    private void onImportTuneButtonClicked(ActionEvent actionEvent) {
        this.basicButtonCoordinator.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse.get(), port -> this.importTune.showFileChooserToImportTuneAction((PortResult)port, this.importTuneButton, this.connectivityContext), () -> JOptionPane.showMessageDialog(this.importTuneButton, "Device is not connected", "Error", 0));
        this.basicButtonCoordinator.refreshButtons();
    }

    private void onExportTuneButtonClicked(ActionEvent actionEvent) {
        this.basicButtonCoordinator.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse.get(), port -> this.exportTune.showFileChooserToExportTuneAction((PortResult)port, this.exportTuneButton, this.connectivityContext), () -> JOptionPane.showMessageDialog(this.exportTuneButton, "Device is not connected", "Error", 0));
        this.basicButtonCoordinator.refreshButtons();
    }
}

