/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageGetterSetter;
import com.opensr5.ini.TableModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.ui.widgets.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TrimsTab {
    private final JPanel content = new JPanel(new BorderLayout());
    private final JTable jTable = new JTable();
    private final JButton loadButton = new JButton("Load Trims");
    private final StatusPanel statusPanel;
    private final ConnectivityContext connectivityContext;
    private final AtomicReference<Optional<PortResult>> ecuPortToUse;

    public TrimsTab(ConnectivityContext connectivityContext, AtomicReference<Optional<PortResult>> ecuPortToUse, StatusPanel statusPanel) {
        this.connectivityContext = connectivityContext;
        this.ecuPortToUse = ecuPortToUse;
        this.statusPanel = statusPanel;
        this.loadButton.addActionListener(e -> this.loadTrims());
        this.content.add((Component)new JScrollPane(this.jTable), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.loadButton, "West");
        bottomPanel.add((Component)statusPanel, "Center");
        this.content.add((Component)bottomPanel, "South");
    }

    private void loadTrims() {
        Optional<PortResult> portResult = this.ecuPortToUse.get();
        if (!portResult.isPresent()) {
            this.statusPanel.logLine("Not connected?");
            return;
        }
        new Thread(() -> {
            SwingUtilities.invokeLater(() -> this.loadButton.setEnabled(false));
            try {
                Optional<CalibrationsInfo> info = CalibrationsHelper.readCurrentCalibrations(((PortResult)portResult.get()).port, this.statusPanel, this.connectivityContext);
                info.ifPresent(calibrationsInfo -> SwingUtilities.invokeLater(() -> this.displayTrims((CalibrationsInfo)calibrationsInfo)));
            }
            finally {
                SwingUtilities.invokeLater(() -> this.loadButton.setEnabled(true));
            }
        }).start();
    }

    private void displayTrims(CalibrationsInfo info) {
        ArrayIniField load;
        String[][] values;
        ArrayIniField rpm;
        String[][] values2;
        ConfigurationImage image = info.getImage().getConfigurationImage();
        TableModel iniTable = info.getIniFile().getTable("ltftBank1Tbl");
        if (iniTable == null) {
            this.statusPanel.logLine("Trims table not found or not an array");
            return;
        }
        Optional<IniField> content = info.getIniFile().findIniField(iniTable.getZBinsConstant());
        Optional<IniField> xBinsField = info.getIniFile().findIniField(iniTable.getXBinsConstant());
        Optional<IniField> tBinsField = info.getIniFile().findIniField(iniTable.getYBinsConstant());
        if (!content.isPresent() || !(content.get() instanceof ArrayIniField)) {
            this.statusPanel.logLine("Trims table not found or not an array");
            return;
        }
        ArrayIniField ltft = (ArrayIniField)content.get();
        String[][] ltftValues = ltft.getValues(ConfigurationImageGetterSetter.getValue(ltft, image));
        String[] rpmBins = null;
        if (xBinsField.isPresent() && xBinsField.get() instanceof ArrayIniField && (values2 = (rpm = (ArrayIniField)xBinsField.get()).getValues(ConfigurationImageGetterSetter.getValue(rpm, image))).length > 0) {
            rpmBins = values2[0];
        }
        String[] loadBins = null;
        if (tBinsField.isPresent() && tBinsField.get() instanceof ArrayIniField && (values = (load = (ArrayIniField)tBinsField.get()).getValues(ConfigurationImageGetterSetter.getValue(load, image))).length > 0) {
            loadBins = values[0];
        }
        this.jTable.setModel(new TrimsTableModel(ltftValues, rpmBins, loadBins));
    }

    public Component getContent() {
        return this.content;
    }

    private static class TrimsTableModel
    extends AbstractTableModel {
        private final String[][] data;
        private final String[] xBins;
        private final String[] yBins;

        public TrimsTableModel(String[][] data, String[] xBins, String[] yBins) {
            this.data = data;
            this.xBins = xBins;
            this.yBins = yBins;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.data[0].length + 1;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Load \\ RPM";
            }
            if (this.xBins != null && column - 1 < this.xBins.length) {
                return this.xBins[column - 1];
            }
            return "Col " + column;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (this.yBins != null && rowIndex < this.yBins.length) {
                    return this.yBins[rowIndex];
                }
                return "Row " + rowIndex;
            }
            return this.data[rowIndex][columnIndex - 1];
        }
    }
}

