/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.lua;

import com.opensr5.ini.field.StringIniField;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.lua.LuaScriptPanel;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class DocumentSizeFilter
extends DocumentFilter {
    private final UIContext context;

    public DocumentSizeFilter(UIContext context) {
        this.context = context;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        boolean isAllowed = this.checkIfAllowed(fb.getDocument(), str, 0);
        if (isAllowed) {
            super.insertString(fb, offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean checkIfAllowed(Document document, String str, int delta) {
        LinkManager linkManager = this.context.getLinkManager();
        BinaryProtocol bp = linkManager.getBinaryProtocol();
        if (bp == null) {
            return true;
        }
        StringIniField field = LuaScriptPanel.getLuaScriptField(bp);
        int limit = field.getSize();
        return document.getLength() + str.length() + delta <= limit;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        boolean isAllowed = this.checkIfAllowed(fb.getDocument(), str, -length);
        if (isAllowed) {
            super.replace(fb, offs, length, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

