/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.updater;

import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.IoStream;
import java.io.IOException;

public class OpenbltDetectorStrategy {
    public static boolean isPortOpenblt(IoStream stream) throws IOException {
        if (stream == null) {
            return false;
        }
        byte[] request = new byte[]{2, -1, 0};
        stream.write(request);
        IncomingDataBuffer idb = stream.getDataBuffer();
        byte responseLength = idb.readByte(250);
        if (responseLength != 8) {
            return false;
        }
        byte[] response = new byte[responseLength];
        idb.waitForBytes(100, "isPortOpenblt", System.currentTimeMillis(), responseLength);
        idb.read(response);
        return response[0] == -1;
    }

    public static boolean streamHasOpenBlt(IoStream stream) throws IOException {
        stream.sendPacket(new byte[]{76});
        byte[] response = stream.getDataBuffer().getPacket(500, "ecuHasOpenblt");
        if (!IoHelper.checkResponseCode(response, (byte)0)) {
            return false;
        }
        return response[1] == 1;
    }
}

