/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.wizard;

import com.devexperts.logging.Logging;
import com.efiAnalytics.plugin.ecu.ControllerAccess;
import com.efiAnalytics.plugin.ecu.ControllerException;
import com.efiAnalytics.plugin.ecu.ControllerParameter;
import com.efiAnalytics.plugin.ecu.OutputChannelClient;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.output.HashUtil;
import com.rusefi.wizard.TsAccess;
import com.rusefi.wizard.TsReflectionHelper;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class BackgroundWizard {
    private static final String ECU_WIZARD_KEY = "wizardPanelToShow";
    private static final Logging log = Logging.getLogging(BackgroundWizard.class);
    private static final int CURRENT_STATE_UNKNOWN = -1;
    private static final int CURRENT_STATE_OFFLINE = 0;
    private static final int CURRENT_STATE_ONLINE = 1;
    static OutputChannelClient onlineListener = new EcuOnlineListener();
    private static Supplier<ControllerAccess> controllerAccessSupplier;
    private static int currentState;
    private static int lastState;
    private static boolean pluginEnabled;
    private static boolean WizardRunToogle;
    private static final String[] WizardEnabledPanels;

    public static void start(Supplier<ControllerAccess> controllerAccessSupplier) {
        BackgroundWizard.controllerAccessSupplier = controllerAccessSupplier;
        Thread thread = new Thread(() -> {
            boolean subscribed = false;
            while (!subscribed) {
                try {
                    controllerAccessSupplier.get().getOutputChannelServer().subscribe("AppEvent", "controllerOnline", onlineListener);
                    subscribed = true;
                }
                catch (Exception e) {
                    log.error("Error subscribing to controllerOnline event: " + e, e);
                    if (currentState == 1) {
                        subscribed = true;
                        continue;
                    }
                    BinaryProtocol.sleep(5000L);
                }
            }
            while (true) {
                try {
                    BackgroundWizard.periodicWizardLogic();
                }
                catch (Throwable e) {
                    log.error("Wizard crash, error " + e, e);
                    WizardRunToogle = true;
                }
                BinaryProtocol.sleep(300L);
            }
        });
        thread.setName("wizard-thread");
        thread.setDaemon(true);
        thread.start();
    }

    private static void periodicWizardLogic() throws ControllerException {
        if (currentState != lastState) {
            if (currentState == -1) {
                log.info("ECU is not connected / no updates from TS");
            } else if (currentState == 0) {
                log.info("ECU is offline");
            } else if (currentState == 1) {
                log.info("ECU is online");
                WizardRunToogle = true;
            }
            lastState = currentState;
        }
        if (currentState == 1 && pluginEnabled && WizardRunToogle) {
            log.info("ECU is online and we can run the wizard");
            String[] mainConfigName = controllerAccessSupplier.get().getEcuConfigurationNames();
            ControllerParameter currentVin = controllerAccessSupplier.get().getControllerParameterServer().getControllerParameter(mainConfigName[0], ECU_WIZARD_KEY);
            int panelToShow = (int)currentVin.getScalarValue();
            if (panelToShow == -1) {
                WizardRunToogle = false;
                return;
            }
            for (String enabledPanel : WizardEnabledPanels) {
                int hash = HashUtil.hash(enabledPanel);
                if (panelToShow != hash) continue;
                BackgroundWizard.launchWizardPanel(enabledPanel);
                WizardRunToogle = false;
                return;
            }
            log.info("FW requested a panel to show, but we can't find it in the list of enabled panels");
            WizardRunToogle = false;
        }
    }

    private static void launchWizardPanel(String panelToOpen) {
        log.info("Launching wizard panel: " + panelToOpen);
        try {
            Frame mainFrame = TsAccess.findTsMainFrame();
            if (mainFrame == null) {
                throw new IllegalStateException("Could not find TunerStudio frame to launch wizard");
            }
            List<AbstractButton> topButtons = TsReflectionHelper.findTopLevelButtons(mainFrame);
            if (topButtons.isEmpty()) {
                topButtons = TsReflectionHelper.findAlternativeButtons(mainFrame);
                for (AbstractButton b : topButtons) {
                    log.info("Found alternative button class: " + b.getClass().getName() + " for text: " + b.getText());
                }
            }
            if (topButtons.isEmpty()) {
                throw new IllegalStateException("no TS top-level buttons");
            }
            ArrayList<AbstractButton> buttonsToTry = new ArrayList<AbstractButton>(topButtons);
            int attempts = Math.max(1, buttonsToTry.size() + 1);
            for (int i = 0; i < attempts; ++i) {
                JMenuItem engineMetaItem;
                AbstractButton topButton;
                AbstractButton abstractButton = topButton = i < buttonsToTry.size() ? (AbstractButton)buttonsToTry.get(i) : null;
                if (topButton != null) {
                    try {
                        SwingUtilities.invokeAndWait(topButton::doClick);
                        BinaryProtocol.sleep(200L);
                    }
                    catch (Exception e) {
                        log.info("Unable to click top-level menu: " + e);
                    }
                }
                if ((engineMetaItem = TsReflectionHelper.findMenuItem(mainFrame, panelToOpen)) == null) continue;
                try {
                    SwingUtilities.invokeAndWait(engineMetaItem::doClick);
                    BinaryProtocol.sleep(200L);
                    JDialog dialog = TsReflectionHelper.waitForDialogWithTitle(panelToOpen, 3L, TimeUnit.SECONDS);
                    if (dialog == null) continue;
                    TsReflectionHelper.bringToFront(dialog);
                    log.info(panelToOpen + " dialog opened");
                    return;
                }
                catch (Exception e) {
                    log.info("Failed to invoke " + panelToOpen + " dialog: " + e);
                }
            }
        }
        catch (Throwable t) {
            log.error("Error launching wizard panel: " + panelToOpen + ": " + t, t);
            BinaryProtocol.sleep(5000L);
            BackgroundWizard.launchWizardPanel(panelToOpen);
        }
    }

    public static boolean displayPlugin(String serialSignature) {
        boolean signatureValid;
        boolean bl = signatureValid = serialSignature != null && !serialSignature.isEmpty();
        if (signatureValid) {
            pluginEnabled = serialSignature.contains("hd81");
        } else {
            log.info("ECU signature invalid for this plugin: " + serialSignature);
        }
        return pluginEnabled;
    }

    public static void onEcuDiscovery(String serialSignature) {
        BackgroundWizard.displayPlugin(serialSignature);
        currentState = 1;
    }

    static {
        currentState = -1;
        lastState = -1;
        pluginEnabled = false;
        WizardRunToogle = true;
        WizardEnabledPanels = new String[]{"Vehicle Information"};
    }

    static class EcuOnlineListener
    implements OutputChannelClient {
        EcuOnlineListener() {
        }

        @Override
        public void setCurrentOutputChannelValue(String string, double d) {
            int newState = (int)d;
            if (currentState == 0 ^ newState == 0) {
                currentState = newState;
            }
        }
    }
}

