/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.PointerType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.Timer;
import javax.swing.border.Border;

public final class Clock
extends AbstractRadial
implements ActionListener {
    private static final double ANGLE_STEP = 6.0;
    private final Timer CLOCK_TIMER;
    private boolean automatic = false;
    private double minutePointerAngle = (double)Calendar.getInstance().get(12) * 6.0;
    private double hourPointerAngle = (double)Calendar.getInstance().get(10) * 6.0 * 5.0 + 0.5 * (double)Calendar.getInstance().get(12);
    private double secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0;
    private final Rectangle INNER_BOUNDS;
    private boolean secondMovesContinuous = false;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage hourImage;
    private BufferedImage hourShadowImage;
    private BufferedImage minuteImage;
    private BufferedImage minuteShadowImage;
    private BufferedImage knobImage;
    private BufferedImage secondImage;
    private BufferedImage secondShadowImage;
    private BufferedImage topKnobImage;
    private BufferedImage disabledImage;
    private int hour = 11;
    private int minute = 55;
    private int second = 0;
    private int timeZoneOffsetHour = 0;
    private int timeZoneOffsetMinute = 0;
    private boolean secondPointerVisible = true;
    private final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
    private int horizontalAlignment;
    private int verticalAlignment;

    public Clock() {
        this.CLOCK_TIMER = new Timer(1000, this);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setPointerColor(ColorDef.BLACK);
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
    }

    @Override
    public AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        this.CENTER.setLocation(this.INNER_BOUNDS.getCenterX() - (double)this.getInsets().top, this.INNER_BOUNDS.getCenterX() - (double)this.getInsets().top);
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getInnerBounds().width) * 0.0841121495, (double)(-this.getInnerBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(WIDTH, WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(WIDTH, this.bImage);
        }
        this.create_TICKMARKS_Image(WIDTH, this.bImage);
        if (this.hourImage != null) {
            this.hourImage.flush();
        }
        this.hourImage = this.create_HOUR_Image(WIDTH);
        if (this.hourShadowImage != null) {
            this.hourShadowImage.flush();
        }
        this.hourShadowImage = this.create_HOUR_SHADOW_Image(WIDTH);
        if (this.minuteImage != null) {
            this.minuteImage.flush();
        }
        this.minuteImage = this.create_MINUTE_Image(WIDTH);
        if (this.minuteShadowImage != null) {
            this.minuteShadowImage.flush();
        }
        this.minuteShadowImage = this.create_MINUTE_SHADOW_Image(WIDTH);
        if (this.knobImage != null) {
            this.knobImage.flush();
        }
        this.knobImage = this.create_KNOB_Image(WIDTH);
        if (this.secondImage != null) {
            this.secondImage.flush();
        }
        this.secondImage = this.create_SECOND_Image(WIDTH);
        if (this.secondShadowImage != null) {
            this.secondShadowImage.flush();
        }
        this.secondShadowImage = this.create_SECOND_SHADOW_Image(WIDTH);
        if (this.topKnobImage != null) {
            this.topKnobImage.flush();
        }
        this.topKnobImage = this.create_TOP_KNOB_Image(WIDTH);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = DISABLED_FACTORY.createRadialDisabled(WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        G2.rotate(Math.toRadians(this.hourPointerAngle + 2.0 * Math.sin(Math.toRadians(this.hourPointerAngle))), this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.hourShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.hourPointerAngle), this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.hourImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.minutePointerAngle + 2.0 * Math.sin(Math.toRadians(this.minutePointerAngle))), this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.minuteShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.minutePointerAngle), this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.minuteImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        if (this.getPointerType() == PointerType.TYPE1) {
            G2.drawImage((Image)this.knobImage, 0, 0, null);
        }
        if (this.secondPointerVisible) {
            G2.rotate(Math.toRadians(this.secondPointerAngle + 2.0 * Math.sin(Math.toRadians(this.secondPointerAngle))), this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.secondShadowImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
            G2.rotate(Math.toRadians(this.secondPointerAngle), this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.secondImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        G2.drawImage((Image)this.topKnobImage, 0, 0, null);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean AUTOMATIC) {
        this.automatic = AUTOMATIC;
        if (AUTOMATIC) {
            if (!this.CLOCK_TIMER.isRunning()) {
                this.CLOCK_TIMER.start();
            }
        } else if (this.CLOCK_TIMER.isRunning()) {
            this.CLOCK_TIMER.stop();
        }
        this.repaint(this.getInnerBounds());
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int HOUR) {
        this.hour = HOUR % 12;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int MINUTE) {
        this.minute = MINUTE % 60;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int SECOND) {
        this.second = SECOND % 60;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getTimeZoneOffsetHour() {
        return this.timeZoneOffsetHour;
    }

    public void setTimeZoneOffsetHour(int TIMEZONE_OFFSET_HOUR) {
        this.timeZoneOffsetHour = TIMEZONE_OFFSET_HOUR;
    }

    public int getTimeZoneOffsetMinute() {
        return this.timeZoneOffsetMinute;
    }

    public void setTimeZoneOffsetMinute(int TIMEZONE_OFFSET_MINUTE) {
        this.timeZoneOffsetMinute = TIMEZONE_OFFSET_MINUTE;
    }

    public boolean isSecondPointerVisible() {
        return this.secondPointerVisible;
    }

    public void setSecondPointerVisible(boolean SECOND_POINTER_VISIBLE) {
        this.secondPointerVisible = SECOND_POINTER_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    public boolean isSecondMovesContinuous() {
        return this.secondMovesContinuous;
    }

    public void setSecondMovesContinuous(boolean SECOND_MOVES_CONTINUOUS) {
        if (SECOND_MOVES_CONTINUOUS) {
            this.CLOCK_TIMER.setDelay(100);
        } else {
            this.CLOCK_TIMER.setDelay(1000);
        }
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.getFrameType()) {
            case SQUARE: {
                BACKGROUND_FACTORY.createLinearBackground(WIDTH, WIDTH, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), image);
                break;
            }
            default: {
                BACKGROUND_FACTORY.createRadialBackground(WIDTH, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), image);
            }
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        Color TICKMARK_COLOR = this.getBackgroundColor().LABEL_COLOR;
        Rectangle2D.Double SMALL_TICK = new Rectangle2D.Double();
        Rectangle2D.Double BIG_TICK = new Rectangle2D.Double();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        switch (this.getPointerType()) {
            case TYPE2: {
                int tickAngle;
                double SMALL_TICK_WIDTH = (double)IMAGE_WIDTH * 0.0140186916;
                double SMALL_TICK_HEIGHT = (double)IMAGE_WIDTH * 0.0373831776;
                SMALL_TICK.setFrame(this.CENTER.getX() - SMALL_TICK_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.0981308411, SMALL_TICK_WIDTH, SMALL_TICK_HEIGHT);
                G2.setColor(TICKMARK_COLOR);
                for (tickAngle = 0; tickAngle < 360; tickAngle += 6) {
                    G2.setTransform(OLD_TRANSFORM);
                    G2.rotate(Math.toRadians(tickAngle), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(SMALL_TICK);
                }
                double BIG_TICK_WIDTH = (double)IMAGE_WIDTH * 0.0327102804;
                double BIG_TICK_HEIGHT = (double)IMAGE_WIDTH * 0.1261682243;
                BIG_TICK.setFrame(this.CENTER.getX() - BIG_TICK_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.0981308411, BIG_TICK_WIDTH, BIG_TICK_HEIGHT);
                for (tickAngle = 0; tickAngle < 360; tickAngle += 30) {
                    G2.setTransform(OLD_TRANSFORM);
                    G2.rotate(Math.toRadians(tickAngle), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(BIG_TICK);
                }
                break;
            }
            default: {
                int tickAngle;
                double SMALL_TICK_WIDTH = (double)IMAGE_WIDTH * 0.0093457944;
                double SMALL_TICK_HEIGHT = (double)IMAGE_WIDTH * 0.0747663551;
                SMALL_TICK.setFrame(this.CENTER.getX() - SMALL_TICK_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.0981308411, SMALL_TICK_WIDTH, SMALL_TICK_HEIGHT);
                for (tickAngle = 0; tickAngle < 360; tickAngle += 30) {
                    G2.setTransform(OLD_TRANSFORM);
                    G2.rotate(Math.toRadians(tickAngle), this.CENTER.getX(), this.CENTER.getY());
                    G2.setColor(TICKMARK_COLOR);
                    G2.fill(SMALL_TICK);
                    G2.setColor(TICKMARK_COLOR.darker());
                    G2.draw(SMALL_TICK);
                }
                double BIG_TICK_WIDTH = (double)IMAGE_WIDTH * 0.0280373832;
                double BIG_TICK_HEIGHT = (double)IMAGE_WIDTH * 0.0841121495;
                BIG_TICK.setFrame(this.CENTER.getX() - BIG_TICK_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.0981308411, BIG_TICK_WIDTH, BIG_TICK_HEIGHT);
                for (tickAngle = 0; tickAngle < 360; tickAngle += 90) {
                    G2.setTransform(OLD_TRANSFORM);
                    G2.rotate(Math.toRadians(tickAngle), this.CENTER.getX(), this.CENTER.getY());
                    G2.setColor(TICKMARK_COLOR);
                    G2.fill(BIG_TICK);
                    G2.setColor(TICKMARK_COLOR.darker());
                    G2.draw(BIG_TICK);
                }
            }
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_HOUR_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double HOUR_POINTER_WIDTH = (double)IMAGE_WIDTH * 0.046728972;
                double HOUR_POINTER_HEIGHT = (double)IMAGE_WIDTH * 0.2242990654;
                Rectangle2D.Double HOUR_POINTER = new Rectangle2D.Double(this.CENTER.getX() - HOUR_POINTER_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.2897196262, HOUR_POINTER_WIDTH, HOUR_POINTER_HEIGHT);
                G2.setPaint(this.getPointerColor().MEDIUM);
                G2.fill(HOUR_POINTER);
                break;
            }
            default: {
                GeneralPath HOURPOINTER = new GeneralPath();
                HOURPOINTER.setWindingRule(0);
                HOURPOINTER.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.21495327102803738);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1822429906542056);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.21495327102803738);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.closePath();
                Point2D.Double HOURPOINTER_START = new Point2D.Double(0.0, HOURPOINTER.getBounds2D().getMaxY());
                Point2D.Double HOURPOINTER_STOP = new Point2D.Double(0.0, HOURPOINTER.getBounds2D().getMinY());
                float[] HOURPOINTER_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] HOURPOINTER_COLORS = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
                LinearGradientPaint HOURPOINTER_GRADIENT = new LinearGradientPaint(HOURPOINTER_START, HOURPOINTER_STOP, HOURPOINTER_FRACTIONS, HOURPOINTER_COLORS);
                G2.setPaint(HOURPOINTER_GRADIENT);
                G2.fill(HOURPOINTER);
                Color STROKE_COLOR_HOURPOINTER = new Color(14343649);
                G2.setColor(STROKE_COLOR_HOURPOINTER);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(HOURPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_HOUR_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                break;
            }
            default: {
                GeneralPath HOURPOINTER = new GeneralPath();
                HOURPOINTER.setWindingRule(0);
                HOURPOINTER.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.21495327102803738);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1822429906542056);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.21495327102803738);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HOURPOINTER.closePath();
                G2.setColor(this.SHADOW_COLOR);
                G2.fill(HOURPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_MINUTE_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double MINUTE_POINTER_WIDTH = (double)IMAGE_WIDTH * 0.0327102804;
                double MINUTE_POINTER_HEIGHT = (double)IMAGE_WIDTH * 0.3878504673;
                Rectangle2D.Double MINUTE_POINTER = new Rectangle2D.Double(this.CENTER.getX() - MINUTE_POINTER_WIDTH / 2.0, (double)IMAGE_WIDTH * 0.1168224299, MINUTE_POINTER_WIDTH, MINUTE_POINTER_HEIGHT);
                G2.setPaint(this.getPointerColor().MEDIUM);
                G2.fill(MINUTE_POINTER);
                break;
            }
            default: {
                GeneralPath MINUTEPOINTER = new GeneralPath();
                MINUTEPOINTER.setWindingRule(0);
                MINUTEPOINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.13551401869158877);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.10747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.14018691588785046);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.closePath();
                Point2D.Double MINUTEPOINTER_START = new Point2D.Double(0.0, MINUTEPOINTER.getBounds2D().getMinY());
                Point2D.Double MINUTEPOINTER_STOP = new Point2D.Double(0.0, MINUTEPOINTER.getBounds2D().getMaxY());
                float[] MINUTEPOINTER_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] MINUTEPOINTER_COLORS = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
                LinearGradientPaint MINUTEPOINTER_GRADIENT = new LinearGradientPaint(MINUTEPOINTER_START, MINUTEPOINTER_STOP, MINUTEPOINTER_FRACTIONS, MINUTEPOINTER_COLORS);
                G2.setPaint(MINUTEPOINTER_GRADIENT);
                G2.fill(MINUTEPOINTER);
                Color STROKE_COLOR_MINUTEPOINTER = new Color(14343649);
                G2.setColor(STROKE_COLOR_MINUTEPOINTER);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(MINUTEPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_MINUTE_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                break;
            }
            default: {
                GeneralPath MINUTEPOINTER = new GeneralPath();
                MINUTEPOINTER.setWindingRule(0);
                MINUTEPOINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.13551401869158877);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.10747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.14018691588785046);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5747663551401869);
                MINUTEPOINTER.closePath();
                G2.setColor(this.SHADOW_COLOR);
                G2.fill(MINUTEPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_KNOB_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath KNOBSHADOW = new GeneralPath();
        KNOBSHADOW.setWindingRule(0);
        KNOBSHADOW.moveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5046728971962616);
        KNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.45794392523364486);
        KNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5046728971962616);
        KNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5560747663551402);
        KNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5046728971962616);
        KNOBSHADOW.closePath();
        Point2D.Double KNOBSHADOW_START = new Point2D.Double(0.0, KNOBSHADOW.getBounds2D().getMinY());
        Point2D.Double KNOBSHADOW_STOP = new Point2D.Double(0.0, KNOBSHADOW.getBounds2D().getMaxY());
        float[] KNOBSHADOW_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] KNOBSHADOW_COLORS = new Color[]{new Color(40, 40, 41, 255), new Color(13, 13, 13, 255)};
        LinearGradientPaint KNOBSHADOW_GRADIENT = new LinearGradientPaint(KNOBSHADOW_START, KNOBSHADOW_STOP, KNOBSHADOW_FRACTIONS, KNOBSHADOW_COLORS);
        G2.setPaint(KNOBSHADOW_GRADIENT);
        G2.fill(KNOBSHADOW);
        GeneralPath KNOB = new GeneralPath();
        KNOB.setWindingRule(0);
        KNOB.moveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5);
        KNOB.curveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.45794392523364486);
        KNOB.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5);
        KNOB.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5420560747663551);
        KNOB.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5);
        KNOB.closePath();
        Point2D.Double KNOB_START = new Point2D.Double(0.0, KNOB.getBounds2D().getMinY());
        Point2D.Double KNOB_STOP = new Point2D.Double(0.0, KNOB.getBounds2D().getMaxY());
        float[] KNOB_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] KNOB_COLORS = new Color[]{new Color(238, 240, 242, 255), new Color(101, 105, 109, 255)};
        LinearGradientPaint KNOB_GRADIENT = new LinearGradientPaint(KNOB_START, KNOB_STOP, KNOB_FRACTIONS, KNOB_COLORS);
        G2.setPaint(KNOB_GRADIENT);
        G2.fill(KNOB);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_SECOND_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                Rectangle2D.Double TOP = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4953271028, (double)IMAGE_WIDTH * 0.0981308411, (double)IMAGE_WIDTH * 0.0093457944, (double)IMAGE_WIDTH * 0.1261682243);
                Rectangle2D.Double BOTTOM = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4906542056, (double)IMAGE_WIDTH * 0.308411215, (double)IMAGE_WIDTH * 0.0186915888, (double)IMAGE_WIDTH * 0.191588785);
                Area SECOND = new Area(TOP);
                SECOND.add(new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.453271028, (double)IMAGE_WIDTH * 0.2196261682, (double)IMAGE_WIDTH * 0.0934579439, (double)IMAGE_WIDTH * 0.0934579439)));
                SECOND.subtract(new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897196, (double)IMAGE_WIDTH * 0.2336448598, (double)IMAGE_WIDTH * 0.0654205607, (double)IMAGE_WIDTH * 0.0654205607)));
                SECOND.add(new Area(BOTTOM));
                GeneralPath SECOND_POINTER = new GeneralPath(SECOND);
                G2.setPaint(ColorDef.RED.MEDIUM);
                G2.fill(SECOND_POINTER);
                break;
            }
            default: {
                GeneralPath SECONDPOINTER = new GeneralPath();
                SECONDPOINTER.setWindingRule(0);
                SECONDPOINTER.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.closePath();
                Point2D.Double SECONDPOINTER_START = new Point2D.Double(SECONDPOINTER.getBounds2D().getMaxX(), 0.0);
                Point2D.Double SECONDPOINTER_STOP = new Point2D.Double(SECONDPOINTER.getBounds2D().getMinX(), 0.0);
                float[] SECONDPOINTER_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                Color[] SECONDPOINTER_COLORS = new Color[]{new Color(236, 123, 125, 255), new Color(231, 27, 33, 255), new Color(166, 40, 46, 255)};
                LinearGradientPaint SECONDPOINTER_GRADIENT = new LinearGradientPaint(SECONDPOINTER_START, SECONDPOINTER_STOP, SECONDPOINTER_FRACTIONS, SECONDPOINTER_COLORS);
                G2.setPaint(SECONDPOINTER_GRADIENT);
                G2.fill(SECONDPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_SECOND_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                Rectangle2D.Double TOP = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4953271028, (double)IMAGE_WIDTH * 0.0981308411, (double)IMAGE_WIDTH * 0.0093457944, (double)IMAGE_WIDTH * 0.1261682243);
                Rectangle2D.Double BOTTOM = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4906542056, (double)IMAGE_WIDTH * 0.308411215, (double)IMAGE_WIDTH * 0.0186915888, (double)IMAGE_WIDTH * 0.191588785);
                Area SECOND = new Area(TOP);
                SECOND.add(new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.453271028, (double)IMAGE_WIDTH * 0.2196261682, (double)IMAGE_WIDTH * 0.0934579439, (double)IMAGE_WIDTH * 0.0934579439)));
                SECOND.subtract(new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897196, (double)IMAGE_WIDTH * 0.2336448598, (double)IMAGE_WIDTH * 0.0654205607, (double)IMAGE_WIDTH * 0.0654205607)));
                SECOND.add(new Area(BOTTOM));
                GeneralPath SECOND_POINTER = new GeneralPath(SECOND);
                G2.setPaint(this.SHADOW_COLOR);
                G2.fill(SECOND_POINTER);
                break;
            }
            default: {
                GeneralPath SECONDPOINTER = new GeneralPath();
                SECONDPOINTER.setWindingRule(0);
                SECONDPOINTER.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.11682242990654206);
                SECONDPOINTER.closePath();
                G2.setPaint(this.SHADOW_COLOR);
                G2.fill(SECONDPOINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_TOP_KNOB_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double CENTER_KNOB_DIAMETER = (double)WIDTH * 0.0887850467;
                Ellipse2D.Double CENTER_KNOB = new Ellipse2D.Double(this.CENTER.getX() - CENTER_KNOB_DIAMETER / 2.0, this.CENTER.getY() - CENTER_KNOB_DIAMETER / 2.0, CENTER_KNOB_DIAMETER, CENTER_KNOB_DIAMETER);
                G2.setPaint(this.getPointerColor().MEDIUM);
                G2.fill(CENTER_KNOB);
                break;
            }
            default: {
                GeneralPath TOPKNOBSHADOW = new GeneralPath();
                TOPKNOBSHADOW.setWindingRule(0);
                TOPKNOBSHADOW.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4719626168224299);
                TOPKNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5280373831775701);
                TOPKNOBSHADOW.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOBSHADOW.closePath();
                Point2D.Double TOPKNOBSHADOW_START = new Point2D.Double(0.0, TOPKNOBSHADOW.getBounds2D().getMinY());
                Point2D.Double TOPKNOBSHADOW_STOP = new Point2D.Double(0.0, TOPKNOBSHADOW.getBounds2D().getMaxY());
                float[] TOPKNOBSHADOW_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] TOPKNOBSHADOW_COLORS = new Color[]{new Color(221, 223, 223, 255), new Color(38, 40, 41, 255)};
                LinearGradientPaint TOPKNOBSHADOW_GRADIENT = new LinearGradientPaint(TOPKNOBSHADOW_START, TOPKNOBSHADOW_STOP, TOPKNOBSHADOW_FRACTIONS, TOPKNOBSHADOW_COLORS);
                G2.setPaint(TOPKNOBSHADOW_GRADIENT);
                G2.fill(TOPKNOBSHADOW);
                GeneralPath TOPKNOB = new GeneralPath();
                TOPKNOB.setWindingRule(0);
                TOPKNOB.moveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOB.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4766355140186916);
                TOPKNOB.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOB.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5233644859813084);
                TOPKNOB.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
                TOPKNOB.closePath();
                Point2D.Double TOPKNOB_START = new Point2D.Double(0.0, TOPKNOB.getBounds2D().getMinY());
                Point2D.Double TOPKNOB_STOP = new Point2D.Double(0.0, TOPKNOB.getBounds2D().getMaxY());
                float[] TOPKNOB_FRACTIONS = new float[]{0.0f, 0.11f, 0.12f, 0.2f, 0.2001f, 1.0f};
                Color[] TOPKNOB_COLORS = new Color[]{new Color(234, 235, 238, 255), new Color(234, 236, 238, 255), new Color(232, 234, 236, 255), new Color(192, 197, 203, 255), new Color(190, 195, 201, 255), new Color(169, 174, 181, 255)};
                LinearGradientPaint TOPKNOB_GRADIENT = new LinearGradientPaint(TOPKNOB_START, TOPKNOB_STOP, TOPKNOB_FRACTIONS, TOPKNOB_COLORS);
                G2.setPaint(TOPKNOB_GRADIENT);
                G2.fill(TOPKNOB);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private void calculateAngles(int HOUR, int MINUTE, int SECOND) {
        this.secondPointerAngle = (double)SECOND * 6.0;
        this.minutePointerAngle = (double)MINUTE * 6.0;
        this.hourPointerAngle = (double)HOUR * 6.0 * 5.0 + 0.5 * (double)this.minute;
    }

    @Override
    public void calcInnerBounds() {
        int SIZE;
        Insets INSETS = this.getInsets();
        int n = SIZE = this.getWidth() - INSETS.left - INSETS.right <= this.getHeight() - INSETS.top - INSETS.bottom ? this.getWidth() - INSETS.left - INSETS.right : this.getHeight() - INSETS.top - INSETS.bottom;
        if (!this.isFrameVisible()) {
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, (int)((double)SIZE * 1.202247191), (int)((double)SIZE * 1.202247191));
        } else {
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, SIZE, SIZE);
        }
    }

    @Override
    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 50 || dim.height < 50) {
            dim = new Dimension(50, 50);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 50 ? 50 : DIM.width;
        int height = DIM.height < 50 ? 50 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMinimumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1080 || dim.height > 1080) {
            dim = new Dimension(1080, 1080);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1080 ? 1080 : DIM.width;
        int height = DIM.height > 1080 ? 1080 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMaximumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setSize(SIZE, SIZE);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        if (BOUNDS.width <= BOUNDS.height) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = BOUNDS.y;
                    break;
                }
                case 3: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width);
                    break;
                }
                default: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width) / 2;
                }
            }
            super.setBounds(BOUNDS.x, yNew, BOUNDS.width, BOUNDS.width);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = BOUNDS.x;
                    break;
                }
                case 4: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height);
                    break;
                }
                default: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height) / 2;
                }
            }
            super.setBounds(xNew, BOUNDS.y, BOUNDS.height, BOUNDS.height);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        if (WIDTH <= HEIGHT) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = Y;
                    break;
                }
                case 3: {
                    yNew = Y + (HEIGHT - WIDTH);
                    break;
                }
                default: {
                    yNew = Y + (HEIGHT - WIDTH) / 2;
                }
            }
            super.setBounds(X, yNew, WIDTH, WIDTH);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = X;
                    break;
                }
                case 4: {
                    xNew = X + (WIDTH - HEIGHT);
                    break;
                }
                default: {
                    xNew = X + (WIDTH - HEIGHT) / 2;
                }
            }
            super.setBounds(xNew, Y, HEIGHT, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int HORIZONTAL_ALIGNMENT) {
        this.horizontalAlignment = HORIZONTAL_ALIGNMENT;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(int VERTICAL_ALIGNMENT) {
        this.verticalAlignment = VERTICAL_ALIGNMENT;
    }

    @Override
    public void dispose() {
        this.CLOCK_TIMER.removeActionListener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.CLOCK_TIMER)) {
            this.secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0 + (double)Calendar.getInstance().get(14) * 6.0 / 1000.0;
            this.hour = Calendar.getInstance().get(10) - this.timeZoneOffsetHour;
            if (this.hour > 12) {
                this.hour -= 12;
            }
            if (this.hour < 0) {
                this.hour += 12;
            }
            this.minute = Calendar.getInstance().get(12) + this.timeZoneOffsetMinute;
            if (this.minute > 60) {
                this.minute -= 60;
                ++this.hour;
            }
            if (this.minute < 0) {
                this.minute += 60;
                --this.hour;
            }
            this.hourPointerAngle = (double)this.hour * 6.0 * 5.0 + 0.5 * (double)this.minute;
            this.minutePointerAngle = (double)this.minute * 6.0;
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void componentResized(ComponentEvent event) {
        int SIZE = this.getWidth() <= this.getHeight() ? this.getWidth() : this.getHeight();
        Container PARENT = this.getParent();
        if (PARENT != null && PARENT.getLayout() == null) {
            if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
                this.setSize(this.getMinimumSize());
            } else {
                this.setSize(SIZE, SIZE);
            }
        } else if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
            this.setSize(this.getMinimumSize());
            this.setPreferredSize(this.getMinimumSize());
        } else {
            this.setSize(new Dimension(SIZE, SIZE));
            this.setPreferredSize(new Dimension(SIZE, SIZE));
        }
        this.calcInnerBounds();
        this.recreateLedImages();
        if (this.isLedOn()) {
            this.setCurrentLedImage(this.getLedImageOn());
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
        }
        this.recreateUserLedImages();
        if (this.isUserLedOn()) {
            this.setCurrentUserLedImage(this.getUserLedImageOn());
        } else {
            this.setCurrentUserLedImage(this.getUserLedImageOff());
        }
        this.getModel().setSize(this.getLocation().x, this.getLocation().y, SIZE, SIZE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public String toString() {
        return "Clock";
    }
}

