/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.extras.Poi;
import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentHashMap;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;

public final class Radar
extends AbstractRadial
implements ActionListener {
    private final Poi MY_LOCATION = new Poi("Home", 0.0, 0.0);
    private double range = 100000.0;
    private static final int INITIAL_WIDTH = 200;
    private double pixelScaleX = this.range / 80.0 / 620.0;
    private double pixelScaleY = this.range / 80.0 / 1000.0;
    private Point2D CENTER_XY = this.MY_LOCATION.getLocationXY();
    private ConcurrentHashMap<String, Poi> pois = new ConcurrentHashMap(64);
    private ConcurrentHashMap<String, Poi> blips = new ConcurrentHashMap(64);
    private final Color BLIP_TEXT_COLOR = new Color(6397541);
    private final Font BLIP_FONT = new Font("Verdana", 0, 6);
    private final Line2D BEAM = new Line2D.Double(100.0, 100.0, 158.0, 158.0);
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage beamImage;
    private BufferedImage disabledImage;
    private final Color BEAM_COLOR = new Color(130, 230, 150, 180);
    private double rotationAngle = 0.0;
    private Timeline timeline = new Timeline(this);

    public Radar() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        this.pixelScaleX = this.range / (0.4 * (double)GAUGE_WIDTH) / 620.0;
        this.pixelScaleY = this.range / (0.4 * (double)GAUGE_WIDTH) / 1000.0;
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, this.bImage);
        }
        this.create_TICKMARKS_Image(GAUGE_WIDTH, this.bImage);
        if (this.beamImage != null) {
            this.beamImage.flush();
        }
        this.beamImage = this.create_BEAM_Image(GAUGE_WIDTH);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        this.BEAM.setLine(this.CENTER.getX(), this.CENTER.getY(), (double)GAUGE_WIDTH * 0.79, (double)GAUGE_HEIGHT * 0.79);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        G2.setColor(this.BLIP_TEXT_COLOR);
        G2.setFont(this.BLIP_FONT);
        for (Poi poi : this.blips.values()) {
            if (!(poi.distanceTo(this.MY_LOCATION) < this.range)) continue;
            G2.drawImage((Image)poi.getPoiImage(), (int)(this.CENTER.getX() - (double)poi.getPoiImage().getWidth() / 2.0 + (poi.getLocationXY().getX() - this.CENTER_XY.getX()) / this.pixelScaleX), (int)(this.CENTER.getY() - (double)poi.getPoiImage().getWidth() / 2.0 + (poi.getLocationXY().getY() - this.CENTER_XY.getY()) / this.pixelScaleY), null);
            G2.drawString(poi.getName(), (int)(this.CENTER.getX() - (double)poi.getPoiImage().getWidth() + (poi.getLocationXY().getX() - this.CENTER_XY.getX()) / this.pixelScaleX), (int)(this.CENTER.getY() - (double)poi.getPoiImage().getWidth() + (poi.getLocationXY().getY() - this.CENTER_XY.getY()) / this.pixelScaleY));
        }
        G2.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.beamImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(-135.0) + this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
        G2.setColor(this.BEAM_COLOR);
        G2.draw(this.BEAM);
        G2.setTransform(OLD_TRANSFORM);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double ROTATION_ANGLE) {
        this.rotationAngle = ROTATION_ANGLE;
        this.repaint();
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double RANGE) {
        this.range = RANGE;
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Poi getMyLocation() {
        return this.MY_LOCATION;
    }

    public void setMyLocation(Poi NEW_LOCATION) {
        this.MY_LOCATION.setLocation(NEW_LOCATION.getLocation());
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public void setMyLocation(double LON, double LAT) {
        this.MY_LOCATION.setLocation(LON, LAT);
        this.checkForBlips();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public void addPoi(Poi BLIP) {
        if (((ConcurrentHashMap.KeySetView)this.pois.keySet()).contains(BLIP.getName())) {
            this.updatePoi(BLIP.getName(), BLIP.getLocation());
        } else {
            this.pois.put(BLIP.getName(), BLIP);
        }
        this.checkForBlips();
    }

    public void updatePoi(String BLIP_NAME, Point2D LOCATION) {
        if (((ConcurrentHashMap.KeySetView)this.pois.keySet()).contains(BLIP_NAME)) {
            this.pois.get(BLIP_NAME).setLocation(LOCATION);
            this.checkForBlips();
        }
    }

    public void removePoi(Poi BLIP) {
        if (((ConcurrentHashMap.KeySetView)this.pois.keySet()).contains(BLIP.getName())) {
            this.pois.remove(BLIP.getName());
            this.checkForBlips();
        }
    }

    public Poi getPoi(String NAME) {
        Poi POINT_OF_INTEREST = ((ConcurrentHashMap.KeySetView)this.pois.keySet()).contains(NAME) ? this.pois.get(NAME) : null;
        return POINT_OF_INTEREST;
    }

    public void animate(boolean RUN) {
        if (this.isEnabled()) {
            if (RUN) {
                if (this.timeline.getState() != Timeline.TimelineState.PLAYING_FORWARD && this.timeline.getState() != Timeline.TimelineState.SUSPENDED) {
                    this.timeline = new Timeline(this);
                    this.timeline.addPropertyToInterpolate("rotationAngle", this.rotationAngle, Math.PI * 2);
                    this.timeline.setEase(new Linear());
                    this.timeline.setDuration(5000L);
                    this.timeline.playLoop(Timeline.RepeatBehavior.LOOP);
                } else if (this.timeline.getState() == Timeline.TimelineState.SUSPENDED) {
                    this.timeline.resume();
                }
            } else {
                this.timeline.suspend();
            }
        }
    }

    private void checkForBlips() {
        this.blips.clear();
        for (Poi poi : this.pois.values()) {
            if (!(poi.distanceTo(this.MY_LOCATION) < this.range) || ((ConcurrentHashMap.KeySetView)this.blips.keySet()).contains(poi.getName())) continue;
            this.blips.put(poi.getName(), poi);
        }
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Ellipse2D.Double E_GAUGE_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double E_GAUGE_BACKGROUND_START = new Point2D.Double(0.0, E_GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double E_GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, E_GAUGE_BACKGROUND.getBounds2D().getMaxY());
        float[] E_GAUGE_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] E_GAUGE_BACKGROUND_COLORS = new Color[]{new Color(7940), new Color(79109)};
        LinearGradientPaint E_GAUGE_BACKGROUND_GRADIENT = new LinearGradientPaint(E_GAUGE_BACKGROUND_START, E_GAUGE_BACKGROUND_STOP, E_GAUGE_BACKGROUND_FRACTIONS, E_GAUGE_BACKGROUND_COLORS);
        G2.setPaint(E_GAUGE_BACKGROUND_GRADIENT);
        G2.fill(E_GAUGE_BACKGROUND);
        Ellipse2D.Double E_GAUGE_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double E_GAUGE_INNERSHADOW_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        float[] E_GAUGE_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.7f, 0.71f, 1.0f};
        Color[] E_GAUGE_INNERSHADOW_COLORS = new Color[]{new Color(0, 90, 40, 0), new Color(0, 90, 40, 0), new Color(0, 90, 40, 0), new Color(0, 90, 40, 76)};
        RadialGradientPaint E_GAUGE_INNERSHADOW_GRADIENT = new RadialGradientPaint(E_GAUGE_INNERSHADOW_CENTER, (float)(0.4158878504672897 * (double)IMAGE_WIDTH), E_GAUGE_INNERSHADOW_FRACTIONS, E_GAUGE_INNERSHADOW_COLORS);
        G2.setPaint(E_GAUGE_INNERSHADOW_GRADIENT);
        G2.fill(E_GAUGE_INNERSHADOW);
        G2.dispose();
        return image;
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int IMAGE_WIDTH = image.getWidth();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        BasicStroke THIN_STROKE = new BasicStroke(0.00390625f * (float)IMAGE_WIDTH, 1, 2);
        Font SMALL_FONT = new Font("Verdana", 0, (int)(0.02f * (float)IMAGE_WIDTH));
        float TEXT_DISTANCE = 0.04f * (float)IMAGE_WIDTH;
        float MIN_LENGTH = 0.015625f * (float)IMAGE_WIDTH;
        float MED_LENGTH = 0.0234375f * (float)IMAGE_WIDTH;
        float MAX_LENGTH = 0.03125f * (float)IMAGE_WIDTH;
        Color TEXT_COLOR = new Color(6397541);
        Color TICK_COLOR = new Color(6397541);
        Color TICK_30_COLOR = new Color(86, 119, 92, 100);
        float RADIUS = (float)IMAGE_WIDTH * 0.4f;
        Point2D.Double TICKMARKS_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_WIDTH / 2.0f);
        Point2D.Double textPoint = null;
        int tickCounter90 = 0;
        int tickCounter30 = 0;
        int tickCounter15 = 0;
        int tickCounter5 = 0;
        int counter = 0;
        double sinValue = 0.0;
        double cosValue = 0.0;
        double STEP = Math.PI / 180;
        for (double alpha = Math.PI * 2; alpha >= 0.0; alpha -= Math.PI / 180) {
            Line2D.Double tick;
            Point2D.Double outerPoint;
            Point2D.Double innerPoint;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            G2.setColor(TICK_COLOR);
            if (tickCounter5 == 5) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)(RADIUS - MIN_LENGTH) * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)(RADIUS - MIN_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter5 = 0;
            }
            if (tickCounter15 == 15) {
                G2.setStroke(THIN_STROKE);
                G2.setColor(TICK_COLOR);
                innerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)(RADIUS - MED_LENGTH) * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)(RADIUS - MED_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter15 = 0;
                tickCounter90 += 15;
            }
            if (tickCounter30 == 30) {
                G2.setStroke(THIN_STROKE);
                G2.setColor(TICK_30_COLOR);
                innerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX(), ((Point2D)TICKMARKS_CENTER).getY());
                outerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)(RADIUS - TEXT_DISTANCE * 1.5f) * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)(RADIUS - TEXT_DISTANCE * 1.5f) * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter30 = 0;
                tickCounter90 += 30;
            }
            if (tickCounter90 == 90) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)(RADIUS - MAX_LENGTH) * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)(RADIUS - MAX_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)RADIUS * cosValue);
                G2.setColor(TICK_COLOR);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter90 = 0;
            }
            G2.setFont(SMALL_FONT);
            G2.setColor(TEXT_COLOR);
            textPoint = new Point2D.Double(((Point2D)TICKMARKS_CENTER).getX() + (double)(RADIUS - TEXT_DISTANCE) * sinValue, ((Point2D)TICKMARKS_CENTER).getY() + (double)(RADIUS - TEXT_DISTANCE) * cosValue);
            if (counter != 360 && counter % 30 == 0) {
                G2.rotate(Math.toRadians(180.0), ((Point2D)TICKMARKS_CENTER).getX(), ((Point2D)TICKMARKS_CENTER).getY());
                G2.fill(UTIL.rotateTextAroundCenter(G2, String.valueOf(counter), (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
            }
            G2.setTransform(OLD_TRANSFORM);
            ++tickCounter5;
            ++tickCounter15;
            ++tickCounter30;
            ++counter;
        }
        double RADIUS_STEP = (double)RADIUS / 5.0;
        for (int i = 1; i < 6; ++i) {
            G2.setColor(TICK_30_COLOR);
            G2.draw(new Ellipse2D.Double(((Point2D)TICKMARKS_CENTER).getX() - (double)i * RADIUS_STEP, ((Point2D)TICKMARKS_CENTER).getY() - (double)i * RADIUS_STEP, (double)(i * 2) * RADIUS_STEP, (double)(i * 2) * RADIUS_STEP));
            if (i >= 5) continue;
            G2.setColor(TICK_COLOR);
            G2.drawString(String.valueOf((int)(this.range / 5000.0 * (double)i)), (int)((Point2D)TICKMARKS_CENTER).getX() + 2, (int)(((Point2D)TICKMARKS_CENTER).getY() - RADIUS_STEP * (double)i - 1.0));
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_BEAM_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Point2D.Double BEAM_CENTER = new Point2D.Double((double)IMAGE_WIDTH / 2.0, (double)IMAGE_HEIGHT / 2.0);
        float[] BEAMAREA_FRACTIONS = new float[]{0.0f, 0.001f, 180.0f, 360.0f};
        Color[] BEAMAREA_COLORS = new Color[]{new Color(55, 178, 72, 100), new Color(0.0f, 0.5f, 0.0f, 0.0f), new Color(0.0f, 0.5f, 0.0f, 0.0f), new Color(55, 178, 72, 100)};
        Ellipse2D.Double BEAM_AREA = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        ConicalGradientPaint BEAM_GRADIENT = new ConicalGradientPaint(true, BEAM_CENTER, 0.0f, BEAMAREA_FRACTIONS, BEAMAREA_COLORS);
        G2.setPaint(BEAM_GRADIENT);
        G2.fill(BEAM_AREA);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public String toString() {
        return "Radar";
    }
}

