/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.ContourGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum FrameImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private Paint outerFrameColor = new Color(0x848484);
    private Paint innerFrameColor = new Color(0.6f, 0.6f, 0.6f, 0.8f);
    private int radWidth = 0;
    private FrameDesign radFrameDesign = FrameDesign.METAL;
    private BufferedImage radFrameImage = this.UTIL.createImage(1, 1, 3);
    private FrameEffect radFrameEffect = FrameEffect.NONE;
    private Paint radCustomFrame = Color.BLACK;
    private Color radFrameBaseColor = new Color(179, 179, 179, 255);
    private boolean radFrameBaseColorEnabled = false;
    private int linWidth = 0;
    private int linHeight = 0;
    private FrameDesign linFrameDesign = FrameDesign.METAL;
    private BufferedImage linFrameImage = this.UTIL.createImage(1, 1, 3);
    private FrameEffect linFrameEffect = FrameEffect.NONE;
    private Paint linCustomFrame = Color.BLACK;
    private Color linFrameBaseColor = new Color(179, 179, 179, 255);
    private boolean linFrameBaseColorEnabled = false;

    public Paint getOuterFrameColor() {
        return this.outerFrameColor;
    }

    public void setOuterFrameColor(Paint OUTER_FRAME_COLOR) {
        this.outerFrameColor = OUTER_FRAME_COLOR;
    }

    public Paint getInnerFrameColor() {
        return this.innerFrameColor;
    }

    public void setInnerFrameColor(Paint INNER_FRAME_COLOR) {
        this.innerFrameColor = INNER_FRAME_COLOR;
    }

    public BufferedImage createRadialFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, FrameEffect FRAME_EFFECT) {
        return this.createRadialFrame(WIDTH, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, new Color(179, 179, 179, 255), false, FRAME_EFFECT, null);
    }

    public BufferedImage createRadialFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, Color FRAME_BASECOLOR, boolean FRAME_BASECOLOR_ENABLED, FrameEffect FRAME_EFFECT) {
        return this.createRadialFrame(WIDTH, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, FRAME_BASECOLOR, FRAME_BASECOLOR_ENABLED, FRAME_EFFECT, null);
    }

    public BufferedImage createRadialFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, FrameEffect FRAME_EFFECT, BufferedImage BACKGROUND_IMAGE) {
        return this.createRadialFrame(WIDTH, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, new Color(179, 179, 179, 255), false, FRAME_EFFECT, BACKGROUND_IMAGE);
    }

    public BufferedImage createRadialFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, Color FRAME_BASECOLOR, boolean FRAME_BASECOLOR_ENABLED, FrameEffect FRAME_EFFECT, BufferedImage BACKGROUND_IMAGE) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == WIDTH && this.radFrameDesign == FRAME_DESIGN && this.radFrameEffect == FRAME_EFFECT && this.radCustomFrame.equals(CUSTOM_FRAME_DESIGN) && this.radFrameBaseColor.equals(FRAME_BASECOLOR) && this.radFrameBaseColorEnabled == FRAME_BASECOLOR_ENABLED) {
            if (BACKGROUND_IMAGE != null) {
                Graphics2D G2 = BACKGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.radFrameImage, 0, 0, null);
                G2.dispose();
            }
            return this.radFrameImage;
        }
        this.radFrameImage.flush();
        this.radFrameImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radFrameImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = WIDTH;
        Area SUBTRACT = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031));
        Area FRAME_OUTERFRAME = new Area(new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT));
        FRAME_OUTERFRAME.subtract(SUBTRACT);
        G2.setPaint(this.outerFrameColor);
        G2.fill(FRAME_OUTERFRAME);
        Area FRAME_MAIN = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.004672897048294544, (double)IMAGE_HEIGHT * 0.004672897048294544, (double)IMAGE_WIDTH * 0.9906542301177979, (double)IMAGE_HEIGHT * 0.9906542301177979));
        FRAME_MAIN.subtract(SUBTRACT);
        Point2D.Double FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
        Point2D.Double FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
        Point2D.Double FRAME_MAIN_CENTER = new Point2D.Double(FRAME_MAIN.getBounds2D().getCenterX(), FRAME_MAIN.getBounds2D().getCenterY());
        if (CUSTOM_FRAME_DESIGN != null && FRAME_DESIGN == FrameDesign.CUSTOM) {
            G2.setPaint(CUSTOM_FRAME_DESIGN);
            G2.fill(FRAME_MAIN);
        } else {
            switch (FRAME_DESIGN) {
                case BLACK_METAL: {
                    float[] frameMainFractions1 = new float[]{0.0f, 45.0f, 125.0f, 180.0f, 245.0f, 315.0f, 360.0f};
                    Color[] frameMainColors1 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainPaint1 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions1, frameMainColors1);
                    G2.setPaint(frameMainPaint1);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case METAL: {
                    float[] frameMainFractions2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors2 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainPaint2 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions2, frameMainColors2);
                    G2.setPaint(frameMainPaint2);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case SHINY_METAL: {
                    float[] frameMainFractions3 = new float[]{0.0f, 45.0f, 90.0f, 125.0f, 180.0f, 235.0f, 270.0f, 315.0f, 360.0f};
                    Color[] frameMainColors3 = FRAME_BASECOLOR_ENABLED ? new Color[]{new Color(254, 254, 254, 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.brighter().brighter().getRed(), FRAME_BASECOLOR.brighter().brighter().getGreen(), FRAME_BASECOLOR.brighter().brighter().getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.brighter().brighter().getRed(), FRAME_BASECOLOR.brighter().brighter().getGreen(), FRAME_BASECOLOR.brighter().brighter().getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(254, 254, 254, 255)} : new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(160, 160, 160, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainPaint3 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions3, frameMainColors3);
                    G2.setPaint(frameMainPaint3);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case GLOSSY_METAL: {
                    G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), (float)IMAGE_WIDTH * 0.5f, new float[]{0.0f, 0.96f, 1.0f}, new Color[]{new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f), new Color(0.8039216f, 0.8f, 0.8039216f, 1.0f), new Color(0.95686275f, 0.95686275f, 0.95686275f, 1.0f)}));
                    G2.fill(FRAME_MAIN);
                    Area FRAME_MAIN_GLOSSY2 = new Area(new Ellipse2D.Double(0.0140186916 * (double)IMAGE_WIDTH, 0.0140186916 * (double)IMAGE_HEIGHT, 0.9719626168 * (double)IMAGE_WIDTH, 0.9719626168 * (double)IMAGE_HEIGHT));
                    FRAME_MAIN_GLOSSY2.subtract(SUBTRACT);
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.0, FRAME_MAIN_GLOSSY2.getBounds2D().getMinY()), new Point2D.Double(0.0, FRAME_MAIN_GLOSSY2.getBounds2D().getMaxY()), new float[]{0.0f, 0.23f, 0.36f, 0.59f, 0.76f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), Color.WHITE, new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.78431374f, 0.7607843f, 0.7529412f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    G2.fill(FRAME_MAIN_GLOSSY2);
                    Area FRAME_MAIN_GLOSSY3 = new Area(new Ellipse2D.Double(0.06542056074766354 * (double)IMAGE_WIDTH, 0.06542056074766354 * (double)IMAGE_HEIGHT, 0.8691588785046729 * (double)IMAGE_WIDTH, 0.8691588785046729 * (double)IMAGE_HEIGHT));
                    FRAME_MAIN_GLOSSY3.subtract(SUBTRACT);
                    G2.setColor(new Color(0xF6F6F6));
                    G2.fill(FRAME_MAIN_GLOSSY3);
                    Area FRAME_MAIN_GLOSSY4 = new Area(new Ellipse2D.Double(FRAME_MAIN_GLOSSY3.getBounds2D().getMinX() + 2.0, FRAME_MAIN_GLOSSY3.getBounds2D().getMinY() + 2.0, FRAME_MAIN_GLOSSY3.getBounds2D().getWidth() - 4.0, FRAME_MAIN_GLOSSY3.getBounds2D().getHeight() - 4.0));
                    FRAME_MAIN_GLOSSY4.subtract(SUBTRACT);
                    G2.setColor(new Color(0x333333));
                    G2.fill(FRAME_MAIN_GLOSSY4);
                    break;
                }
                case BRASS: {
                    float[] frameMainFractions4 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors4 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint frameMainPaint4 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions4, frameMainColors4);
                    G2.setPaint(frameMainPaint4);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case STEEL: {
                    float[] frameMainFractions5 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors5 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint frameMainPaint5 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions5, frameMainColors5);
                    G2.setPaint(frameMainPaint5);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case CHROME: {
                    float[] frameMainFractions6 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] frameMainColors6 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint frameMainPaint6 = new ConicalGradientPaint(false, FRAME_MAIN_CENTER, 0.0f, frameMainFractions6, frameMainColors6);
                    G2.setPaint(frameMainPaint6);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case GOLD: {
                    float[] frameMainFractions7 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] frameMainColors7 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint frameMainPaint7 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions7, frameMainColors7);
                    G2.setPaint(frameMainPaint7);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case ANTHRACITE: {
                    float[] frameMainFractions8 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] frameMainColors8 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint frameMainPaint8 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions8, frameMainColors8);
                    G2.setPaint(frameMainPaint8);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.2336448598130841 * (double)IMAGE_WIDTH, 0.08411214953271028 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8125818236066633 * (double)IMAGE_WIDTH, 0.9109198204038422 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions9 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] frameMainColors9 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint frameMainPaint9 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions9, frameMainColors9);
                    G2.setPaint(frameMainPaint9);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.22897196261682243 * (double)IMAGE_WIDTH, 0.0794392523364486 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8025483989678684 * (double)IMAGE_WIDTH, 0.8985912966254403 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions10 = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] frameMainColors10 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint frameMainPaint10 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions10, frameMainColors10);
                    G2.setPaint(frameMainPaint10);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                default: {
                    float[] frameMainFractions = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainPaint = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions, frameMainColors);
                    G2.setPaint(frameMainPaint);
                    G2.fill(FRAME_MAIN);
                }
            }
        }
        Area FRAME_INNERFRAME = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.07943925261497498, (double)IMAGE_HEIGHT * 0.07943925261497498, (double)IMAGE_WIDTH * 0.8411215543746948, (double)IMAGE_HEIGHT * 0.8411215543746948));
        FRAME_INNERFRAME.subtract(SUBTRACT);
        G2.setPaint(this.innerFrameColor);
        G2.fill(FRAME_INNERFRAME);
        Point2D.Double EFFECT_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        switch (FRAME_EFFECT) {
            default: {
                break;
            }
            case EFFECT_BULGE: {
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.82f, 0.83f, 0.86f, 0.87f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 76), new Color(0, 0, 0, 95), new Color(219, 219, 219, 153), new Color(255, 255, 255, 151), new Color(0, 0, 0, 102)};
                RadialGradientPaint EFFECT_GRADIENT = new RadialGradientPaint(EFFECT_CENTER, 0.5f * (float)IMAGE_WIDTH, EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(FRAME_OUTERFRAME);
                break;
            }
            case EFFECT_CONE: {
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.82f, 0.8201f, 0.96f, 0.9601f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 50), new Color(9, 9, 9, 51), new Color(255, 255, 255, 124), new Color(223, 223, 223, 127), new Color(0, 0, 0, 76)};
                RadialGradientPaint EFFECT_GRADIENT = new RadialGradientPaint(EFFECT_CENTER, (float)(0.5 * (double)IMAGE_WIDTH), EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(FRAME_OUTERFRAME);
                break;
            }
            case EFFECT_TORUS: {
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.82f, 0.8201f, 0.92f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 50), new Color(13, 13, 13, 51), new Color(255, 255, 255, 64), new Color(0, 0, 0, 76)};
                RadialGradientPaint EFFECT_GRADIENT = new RadialGradientPaint(EFFECT_CENTER, (float)(0.5 * (double)IMAGE_WIDTH), EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(FRAME_OUTERFRAME);
                break;
            }
            case EFFECT_INNER_FRAME: {
                Ellipse2D.Double EFFECT_BIGINNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.0607476644217968, (double)IMAGE_HEIGHT * 0.0607476644217968, (double)IMAGE_WIDTH * 0.8785046339035034, (double)IMAGE_HEIGHT * 0.8785046339035034);
                Point2D.Double EFFECT_BIGINNERFRAME_START = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMinY());
                Point2D.Double EFFECT_BIGINNERFRAME_STOP = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMaxY());
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                LinearGradientPaint EFFECT_BIGINNERFRAME_GRADIENT = new LinearGradientPaint(EFFECT_BIGINNERFRAME_START, EFFECT_BIGINNERFRAME_STOP, EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_BIGINNERFRAME_GRADIENT);
                G2.fill(EFFECT_BIGINNERFRAME);
            }
        }
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.radFrameImage, 0, 0, null);
            G.dispose();
        }
        this.radWidth = WIDTH;
        this.radFrameDesign = FRAME_DESIGN;
        this.radFrameEffect = FRAME_EFFECT;
        this.radCustomFrame = CUSTOM_FRAME_DESIGN;
        this.radFrameBaseColor = FRAME_BASECOLOR;
        this.radFrameBaseColorEnabled = FRAME_BASECOLOR_ENABLED;
        return this.radFrameImage;
    }

    public BufferedImage createLinearFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, FrameEffect FRAME_EFFECT) {
        return this.createLinearFrame(WIDTH, WIDTH, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, FRAME_EFFECT);
    }

    public BufferedImage createLinearFrame(int WIDTH, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, Color FRAME_BASECOLOR, boolean FRAME_BASECOLOR_ENABLED, FrameEffect FRAME_EFFECT) {
        return this.createLinearFrame(WIDTH, WIDTH, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, FRAME_BASECOLOR, FRAME_BASECOLOR_ENABLED, FRAME_EFFECT, null);
    }

    public BufferedImage createLinearFrame(int WIDTH, int HEIGHT, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, FrameEffect FRAME_EFFECT) {
        return this.createLinearFrame(WIDTH, HEIGHT, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, FRAME_EFFECT, null);
    }

    public BufferedImage createLinearFrame(int WIDTH, int HEIGHT, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, FrameEffect FRAME_EFFECT, BufferedImage BACKGROUND_IMAGE) {
        return this.createLinearFrame(WIDTH, HEIGHT, FRAME_DESIGN, CUSTOM_FRAME_DESIGN, new Color(179, 179, 179, 255), false, FRAME_EFFECT, BACKGROUND_IMAGE);
    }

    public BufferedImage createLinearFrame(int WIDTH, int HEIGHT, FrameDesign FRAME_DESIGN, Paint CUSTOM_FRAME_DESIGN, Color FRAME_BASECOLOR, boolean FRAME_BASECOLOR_ENABLED, FrameEffect FRAME_EFFECT, BufferedImage BACKGROUND_IMAGE) {
        if (WIDTH <= 2 || HEIGHT <= 2) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == WIDTH && this.linHeight == HEIGHT && this.linFrameDesign == FRAME_DESIGN && this.linFrameEffect == FRAME_EFFECT && this.linCustomFrame.equals(CUSTOM_FRAME_DESIGN) && this.linFrameBaseColor.equals(FRAME_BASECOLOR) && this.linFrameBaseColorEnabled == FRAME_BASECOLOR_ENABLED) {
            if (BACKGROUND_IMAGE != null) {
                Graphics2D G2 = BACKGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.linFrameImage, 0, 0, null);
                G2.dispose();
            }
            return this.linFrameImage;
        }
        this.linFrameImage.flush();
        this.linFrameImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.linFrameImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = HEIGHT;
        double OUTER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.05 : (double)IMAGE_WIDTH * 0.05;
        Area OUTER_FRAME = new Area(new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, OUTER_FRAME_CORNER_RADIUS, OUTER_FRAME_CORNER_RADIUS));
        G2.setPaint(this.outerFrameColor);
        double FRAME_MAIN_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? OUTER_FRAME_CORNER_RADIUS - (OUTER_FRAME.getBounds2D().getHeight() - (double)IMAGE_HEIGHT - 2.0) / 2.0 : OUTER_FRAME_CORNER_RADIUS - (OUTER_FRAME.getBounds2D().getWidth() - (double)IMAGE_WIDTH - 2.0) / 2.0;
        Area FRAME_MAIN = new Area(new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FRAME_MAIN_CORNER_RADIUS, FRAME_MAIN_CORNER_RADIUS));
        Point2D.Double FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
        Point2D.Double FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
        Point2D.Double FRAME_MAIN_CENTER = new Point2D.Double(FRAME_MAIN.getBounds2D().getCenterX(), FRAME_MAIN.getBounds2D().getCenterY());
        double SUBTRACT_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.02857143 : (double)IMAGE_WIDTH * 0.02857143;
        Area SUBTRACT = new Area(new RoundRectangle2D.Double(FRAME_MAIN.getBounds2D().getX() + 16.0, FRAME_MAIN.getBounds2D().getY() + 16.0, FRAME_MAIN.getBounds2D().getWidth() - 32.0, FRAME_MAIN.getBounds2D().getHeight() - 32.0, SUBTRACT_CORNER_RADIUS, SUBTRACT_CORNER_RADIUS));
        OUTER_FRAME.subtract(SUBTRACT);
        G2.fill(OUTER_FRAME);
        float ANGLE_OFFSET = (float)Math.toDegrees(Math.atan((float)IMAGE_HEIGHT / 8.0f / ((float)IMAGE_WIDTH / 2.0f)));
        if (CUSTOM_FRAME_DESIGN != null && FRAME_DESIGN == FrameDesign.CUSTOM) {
            G2.setPaint(CUSTOM_FRAME_DESIGN);
            FRAME_MAIN.subtract(SUBTRACT);
            G2.fill(FRAME_MAIN);
        } else {
            switch (FRAME_DESIGN) {
                case BLACK_METAL: {
                    float[] frameMainFractions1 = new float[]{0.0f, 90.0f - 2.0f * ANGLE_OFFSET, 90.0f, 90.0f + 3.0f * ANGLE_OFFSET, 180.0f, 270.0f - 3.0f * ANGLE_OFFSET, 270.0f, 270.0f + 2.0f * ANGLE_OFFSET, 1.0f};
                    Color[] frameMainColors1 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainGradient1 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions1, frameMainColors1);
                    G2.setPaint(frameMainGradient1);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case METAL: {
                    float[] frameMainFractions2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors2 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient2 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions2, frameMainColors2);
                    G2.setPaint(frameMainGradient2);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case SHINY_METAL: {
                    float[] frameMainFractions3 = new float[]{0.0f, 90.0f - 2.0f * ANGLE_OFFSET, 90.0f, 90.0f + 3.0f * ANGLE_OFFSET, 180.0f, 270.0f - 3.0f * ANGLE_OFFSET, 270.0f, 270.0f + 2.0f * ANGLE_OFFSET, 1.0f};
                    Color[] frameMainColors3 = FRAME_BASECOLOR_ENABLED ? new Color[]{new Color(254, 254, 254, 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.brighter().brighter().getRed(), FRAME_BASECOLOR.brighter().brighter().getGreen(), FRAME_BASECOLOR.brighter().brighter().getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(FRAME_BASECOLOR.brighter().brighter().getRed(), FRAME_BASECOLOR.brighter().brighter().getGreen(), FRAME_BASECOLOR.brighter().brighter().getBlue(), 255), new Color(FRAME_BASECOLOR.getRed(), FRAME_BASECOLOR.getGreen(), FRAME_BASECOLOR.getBlue(), 255), new Color(254, 254, 254, 255)} : new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainGradient3 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions3, frameMainColors3);
                    G2.setPaint(frameMainGradient3);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case GLOSSY_METAL: {
                    float relFrameSize = WIDTH >= HEIGHT ? 32.0f / (float)HEIGHT : 32.0f / (float)WIDTH;
                    float[] frameMainFractions4 = new float[]{0.0f, relFrameSize * 0.04f, 1.0f};
                    Color[] frameMainColors4 = new Color[]{new Color(0.95686275f, 0.95686275f, 0.95686275f, 1.0f), new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f), new Color(0.8117647f, 0.8117647f, 0.8117647f, 1.0f)};
                    ContourGradientPaint frameMainGradient4 = new ContourGradientPaint(OUTER_FRAME.getBounds2D(), frameMainFractions4, frameMainColors4);
                    G2.setPaint(frameMainGradient4);
                    G2.fill(FRAME_MAIN);
                    Area FRAME_MAIN_GLOSSY2 = new Area(new RoundRectangle2D.Double(2.0, 2.0, IMAGE_WIDTH - 4, IMAGE_HEIGHT - 4, FRAME_MAIN_CORNER_RADIUS, FRAME_MAIN_CORNER_RADIUS));
                    FRAME_MAIN_GLOSSY2.subtract(SUBTRACT);
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.0, FRAME_MAIN_GLOSSY2.getBounds2D().getMinY()), new Point2D.Double(0.0, FRAME_MAIN_GLOSSY2.getBounds2D().getMaxY()), new float[]{0.0f, 0.1f, 0.26f, 0.73f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    G2.fill(FRAME_MAIN_GLOSSY2);
                    Area FRAME_MAIN_GLOSSY3 = new Area(new RoundRectangle2D.Double(15.0, 15.0, IMAGE_WIDTH - 30, IMAGE_HEIGHT - 30, SUBTRACT_CORNER_RADIUS, SUBTRACT_CORNER_RADIUS));
                    FRAME_MAIN_GLOSSY3.subtract(SUBTRACT);
                    G2.setPaint(new Color(0xF6F6F6));
                    G2.fill(FRAME_MAIN_GLOSSY3);
                    Area FRAME_MAIN_GLOSSY4 = new Area(new RoundRectangle2D.Double(16.0, 16.0, IMAGE_WIDTH - 32, IMAGE_HEIGHT - 32, SUBTRACT_CORNER_RADIUS, SUBTRACT_CORNER_RADIUS));
                    FRAME_MAIN_GLOSSY4.subtract(SUBTRACT);
                    G2.setPaint(new Color(0x333333));
                    G2.fill(FRAME_MAIN_GLOSSY4);
                    break;
                }
                case BRASS: {
                    float[] frameMainFractions5 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors5 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint frameMainGradient5 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions5, frameMainColors5);
                    G2.setPaint(frameMainGradient5);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case STEEL: {
                    float[] frameMainFractions6 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors6 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint frameMainGradient6 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions6, frameMainColors6);
                    G2.setPaint(frameMainGradient6);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case CHROME: {
                    float[] frameMainFractions7 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] frameMainColors7 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint frameMainGradient7 = new ConicalGradientPaint(false, FRAME_MAIN_CENTER, 0.0f, frameMainFractions7, frameMainColors7);
                    G2.setPaint(frameMainGradient7);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case GOLD: {
                    float[] frameMainFractions8 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] frameMainColors8 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint frameMainGradient8 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions8, frameMainColors8);
                    G2.setPaint(frameMainGradient8);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case ANTHRACITE: {
                    float[] frameMainFractions9 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] frameMainColors9 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint frameMainGradient9 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions9, frameMainColors9);
                    G2.setPaint(frameMainGradient9);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.08571428571428572 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8293857071807453 * (double)IMAGE_WIDTH, 0.9868853088441548 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions10 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] frameMainColors10 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint frameMainGradient10 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions10, frameMainColors10);
                    G2.setPaint(frameMainGradient10);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.08571428571428572 * (double)IMAGE_WIDTH, 0.014285714285714285 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.7353908489107824 * (double)IMAGE_WIDTH, 1.01469989176347 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions11 = new float[]{0.0f, 0.21f, 0.47f, 1.0f};
                    Color[] frameMainColors11 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint frameMainGradient11 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions11, frameMainColors11);
                    G2.setPaint(frameMainGradient11);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                    break;
                }
                default: {
                    float[] frameMainFractions = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions, frameMainColors);
                    G2.setPaint(frameMainGradient);
                    FRAME_MAIN.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN);
                }
            }
        }
        switch (FRAME_EFFECT) {
            default: {
                break;
            }
            case EFFECT_BULGE: {
                float relFrameSize = WIDTH >= HEIGHT ? 32.0f / (float)HEIGHT : 32.0f / (float)WIDTH;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, relFrameSize * 0.87f, relFrameSize * 0.86f, relFrameSize * 0.83f, relFrameSize, relFrameSize * 1.01f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(219, 219, 219, 153), new Color(36, 36, 36, 76), new Color(0, 0, 0, 95), new Color(0, 0, 0, 0)};
                ContourGradientPaint EFFECT_GRADIENT = new ContourGradientPaint(OUTER_FRAME.getBounds2D(), EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(OUTER_FRAME);
                break;
            }
            case EFFECT_CONE: {
                float relFrameSize = WIDTH >= HEIGHT ? 32.0f / (float)HEIGHT : 32.0f / (float)WIDTH;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, relFrameSize * 0.1f, relFrameSize * 0.3f, relFrameSize, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
                ContourGradientPaint EFFECT_GRADIENT = new ContourGradientPaint(OUTER_FRAME.getBounds2D(), EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(OUTER_FRAME);
                break;
            }
            case EFFECT_TORUS: {
                float relFrameSize = WIDTH >= HEIGHT ? 32.0f / (float)HEIGHT : 32.0f / (float)WIDTH;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, relFrameSize * 0.1f, relFrameSize * 0.5f, relFrameSize, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
                ContourGradientPaint EFFECT_GRADIENT = new ContourGradientPaint(OUTER_FRAME.getBounds2D(), EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_GRADIENT);
                G2.fill(OUTER_FRAME);
                break;
            }
            case EFFECT_INNER_FRAME: {
                RoundRectangle2D.Double EFFECT_BIGINNERFRAME = new RoundRectangle2D.Double(10.0, 10.0, IMAGE_WIDTH - 20, IMAGE_HEIGHT - 20, 10.0, 10.0);
                Point2D.Double EFFECT_BIGINNERFRAME_START = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMinY());
                Point2D.Double EFFECT_BIGINNERFRAME_STOP = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMaxY());
                float[] EFFECT_BIGINNERFRAME_FRACTIONS = new float[]{0.0f, 0.13f, 0.45f, 0.92f, 1.0f};
                Color[] EFFECT_BIGINNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 183), new Color(0, 0, 0, 25), new Color(0, 0, 0, 160), new Color(0, 0, 0, 80), new Color(255, 255, 255, 158)};
                LinearGradientPaint EFFECT_BIGINNERFRAME_GRADIENT = new LinearGradientPaint(EFFECT_BIGINNERFRAME_START, EFFECT_BIGINNERFRAME_STOP, EFFECT_BIGINNERFRAME_FRACTIONS, EFFECT_BIGINNERFRAME_COLORS);
                G2.setPaint(EFFECT_BIGINNERFRAME_GRADIENT);
                G2.fill(EFFECT_BIGINNERFRAME);
            }
        }
        double INNER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.02857143 : (double)IMAGE_WIDTH * 0.02857143;
        Area INNER_FRAME = new Area(new RoundRectangle2D.Double(FRAME_MAIN.getBounds2D().getX() + 16.0, FRAME_MAIN.getBounds2D().getY() + 16.0, FRAME_MAIN.getBounds2D().getWidth() - 32.0, FRAME_MAIN.getBounds2D().getHeight() - 32.0, INNER_FRAME_CORNER_RADIUS, INNER_FRAME_CORNER_RADIUS));
        G2.setPaint(this.innerFrameColor);
        INNER_FRAME.subtract(SUBTRACT);
        G2.fill(INNER_FRAME);
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.linFrameImage, 0, 0, null);
            G.dispose();
        }
        this.linWidth = WIDTH;
        this.linHeight = HEIGHT;
        this.linFrameDesign = FRAME_DESIGN;
        this.linFrameEffect = FRAME_EFFECT;
        this.linCustomFrame = CUSTOM_FRAME_DESIGN;
        this.linFrameBaseColor = FRAME_BASECOLOR;
        this.linFrameBaseColorEnabled = FRAME_BASECOLOR_ENABLED;
        return this.linFrameImage;
    }

    public String toString() {
        return "FrameImageFactory";
    }
}

