/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public enum PointerImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private PointerType radPointerType = PointerType.TYPE1;
    private ColorDef radPointerColor = null;
    private CustomColorDef radCustomPointerColor = new CustomColorDef(Color.RED);
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private BufferedImage radPointerImage = this.UTIL.createImage(1, 1, 3);
    private int radWidthShadow = 0;
    private PointerType radPointerTypeShadow = PointerType.TYPE1;
    private BufferedImage radPointerShadowImage = this.UTIL.createImage(1, 1, 3);

    public BufferedImage createStandardPointer(int WIDTH, PointerType POINTER_TYPE, ColorDef POINTER_COLOR, BackgroundColor BACKGROUND_COLOR) {
        return this.createStandardPointer(WIDTH, POINTER_TYPE, POINTER_COLOR, null, BACKGROUND_COLOR);
    }

    public BufferedImage createStandardPointer(int WIDTH, PointerType POINTER_TYPE, ColorDef POINTER_COLOR, CustomColorDef CUSTOM_POINTER_COLOR, BackgroundColor BACKGROUND_COLOR) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == WIDTH && this.radPointerType == POINTER_TYPE && this.radPointerColor == POINTER_COLOR && this.radCustomPointerColor == CUSTOM_POINTER_COLOR && this.backgroundColor == BACKGROUND_COLOR) {
            return this.radPointerImage;
        }
        this.radPointerImage.flush();
        this.radPointerImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radPointerImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = this.radPointerImage.getWidth();
        int IMAGE_HEIGHT = this.radPointerImage.getHeight();
        switch (POINTER_TYPE) {
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.46261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.3411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.3411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.46261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{BACKGROUND_COLOR.LABEL_COLOR, BACKGROUND_COLOR.LABEL_COLOR, POINTER_COLOR.LIGHT, POINTER_COLOR.LIGHT} : new Color[]{BACKGROUND_COLOR.LABEL_COLOR, BACKGROUND_COLOR.LABEL_COLOR, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                GeneralPath POINTER = new GeneralPath(new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.009345794392523364, (double)IMAGE_HEIGHT * 0.37383177570093457));
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setColor(POINTER_COLOR.LIGHT);
                } else {
                    G2.setColor(CUSTOM_POINTER_COLOR.LIGHT);
                }
                G2.fill(POINTER);
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.13551401869158877);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.13551401869158877);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1261682242990654);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.DARK, POINTER_COLOR.DARK, POINTER_COLOR.LIGHT, POINTER_COLOR.LIGHT} : new Color[]{CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.LIGHT, POINTER_COLOR.LIGHT, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM} : new Color[]{CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setColor(POINTER_COLOR.DARK);
                } else {
                    G2.setColor(CUSTOM_POINTER_COLOR.DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.3925233644859813);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3878504672897196);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3878504672897196);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3925233644859813);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMaxY(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMinY(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.LIGHT, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM, POINTER_COLOR.LIGHT} : new Color[]{CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setColor(POINTER_COLOR.DARK);
                } else {
                    G2.setColor(CUSTOM_POINTER_COLOR.DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.DARK, POINTER_COLOR.MEDIUM} : new Color[]{CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.LIGHT, POINTER_COLOR.LIGHT, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM} : new Color[]{CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setColor(POINTER_COLOR.DARK);
                } else {
                    G2.setColor(CUSTOM_POINTER_COLOR.DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4392523364485981);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4392523364485981);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5280373831775701);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6074766355140186);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5280373831775701);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.48f, 1.0f};
                Color[] POINTER_COLORS = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(new Color(0x2E2E2E));
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                GeneralPath COLORED_BOX = new GeneralPath();
                COLORED_BOX.setWindingRule(0);
                COLORED_BOX.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.21962616822429906);
                COLORED_BOX.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.21962616822429906);
                COLORED_BOX.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.13551401869158877);
                COLORED_BOX.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.13551401869158877);
                COLORED_BOX.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.21962616822429906);
                COLORED_BOX.closePath();
                G2.setColor(POINTER_COLOR.MEDIUM);
                G2.fill(COLORED_BOX);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5560747663551402);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.LIGHT, POINTER_COLOR.LIGHT, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM} : new Color[]{CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(POINTER_COLOR.MEDIUM);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.48130841121495327 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.514018691588785 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT, 0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(new Point2D.Double(0.0, POINTER.getBounds2D().getMinY()), new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY()), new float[]{0.0f, 1.0f}, new Color[]{POINTER_COLOR.MEDIUM, POINTER_COLOR.DARK});
                    G2.setPaint(POINTER_GRADIENT);
                    G2.fill(POINTER);
                    G2.setColor(POINTER_COLOR.VERY_DARK);
                } else {
                    LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(new Point2D.Double(0.0, POINTER.getBounds2D().getMinY()), new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY()), new float[]{0.0f, 1.0f}, new Color[]{CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.DARK});
                    G2.setPaint(POINTER_GRADIENT);
                    G2.fill(POINTER);
                    G2.setColor(CUSTOM_POINTER_COLOR.VERY_DARK);
                }
                G2.setStroke(new BasicStroke(0.004672897f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.5046728971962616 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5046728971962616 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{POINTER_COLOR.MEDIUM, POINTER_COLOR.DARK}));
                    G2.fill(POINTER);
                    G2.setColor(POINTER_COLOR.VERY_DARK);
                } else {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5046728971962616 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.DARK}));
                    G2.fill(POINTER);
                    G2.setColor(CUSTOM_POINTER_COLOR.VERY_DARK);
                }
                G2.setStroke(new BasicStroke(0.004672897f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{BACKGROUND_COLOR.LABEL_COLOR, BACKGROUND_COLOR.LABEL_COLOR, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM}));
                } else {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{BACKGROUND_COLOR.LABEL_COLOR, BACKGROUND_COLOR.LABEL_COLOR, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM}));
                }
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                if (POINTER_COLOR != ColorDef.CUSTOM) {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.48598130841121495 * (double)IMAGE_WIDTH, 0.0), new Point2D.Double(0.5093457943925234 * (double)IMAGE_HEIGHT, 0.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{POINTER_COLOR.VERY_DARK, POINTER_COLOR.LIGHT, POINTER_COLOR.VERY_DARK}));
                } else {
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.48598130841121495 * (double)IMAGE_WIDTH, 0.0), new Point2D.Double(0.5093457943925234 * (double)IMAGE_HEIGHT, 0.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{CUSTOM_POINTER_COLOR.VERY_DARK, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.VERY_DARK}));
                }
                G2.fill(POINTER);
                break;
            }
            case TYPE15: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48 * (double)IMAGE_WIDTH, 0.505 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.46 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.495 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.53 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.515 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.515 * (double)IMAGE_WIDTH, 0.505 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.46 * (double)IMAGE_WIDTH, 0.26 * (double)IMAGE_HEIGHT);
                Point2D.Double POINTER_STOP = new Point2D.Double(0.53 * (double)IMAGE_WIDTH, 0.26 * (double)IMAGE_HEIGHT);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.VERY_DARK, POINTER_COLOR.MEDIUM, POINTER_COLOR.VERY_DARK} : new Color[]{CUSTOM_POINTER_COLOR.VERY_DARK, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.VERY_DARK};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            default: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.40186915887850466);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.397196261682243);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3f, 0.6f, 1.0f};
                Color[] POINTER_COLORS = POINTER_COLOR != ColorDef.CUSTOM ? new Color[]{POINTER_COLOR.VERY_DARK, POINTER_COLOR.MEDIUM, POINTER_COLOR.MEDIUM, POINTER_COLOR.VERY_DARK} : new Color[]{CUSTOM_POINTER_COLOR.VERY_DARK, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.MEDIUM, CUSTOM_POINTER_COLOR.VERY_DARK};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(POINTER_COLOR.LIGHT);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
            }
        }
        G2.dispose();
        this.radWidth = WIDTH;
        this.radPointerType = POINTER_TYPE;
        this.radPointerColor = POINTER_COLOR;
        this.backgroundColor = BACKGROUND_COLOR;
        this.radCustomPointerColor = CUSTOM_POINTER_COLOR;
        return this.radPointerImage;
    }

    public BufferedImage createStandardPointerShadow(int WIDTH, PointerType POINTER_TYPE) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidthShadow == WIDTH && this.radPointerTypeShadow == POINTER_TYPE) {
            return this.radPointerShadowImage;
        }
        Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        this.radPointerShadowImage.flush();
        this.radPointerShadowImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radPointerShadowImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = this.radPointerShadowImage.getWidth();
        int IMAGE_HEIGHT = this.radPointerShadowImage.getHeight();
        switch (POINTER_TYPE) {
            case TYPE1: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.40186915887850466);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.397196261682243);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.46261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.3411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.3411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.46261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1261682242990654);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.13551401869158877);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.13551401869158877);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1261682242990654);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.3925233644859813);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3878504672897196);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3878504672897196);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3925233644859813);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48598130841121495);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4392523364485981);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4392523364485981);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5280373831775701);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6074766355140186);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5280373831775701);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4719626168224299);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.1308411214953271);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5560747663551402);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.48130841121495327 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.514018691588785 * (double)IMAGE_WIDTH, 0.5841121495327103 * (double)IMAGE_HEIGHT, 0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.5046728971962616 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.1308411214953271 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.5093457943925234 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.16822429906542055 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE15: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.48 * (double)IMAGE_WIDTH, 0.505 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.48 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.46 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.495 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.53 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.515 * (double)IMAGE_WIDTH, 0.275 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.515 * (double)IMAGE_WIDTH, 0.505 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
            }
        }
        G2.dispose();
        this.radWidthShadow = WIDTH;
        this.radPointerTypeShadow = POINTER_TYPE;
        return this.radPointerShadowImage;
    }

    public String toString() {
        return "PointerImageFactory";
    }
}

