/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.io;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleInfo;
import java.util.function.Function;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class BundleInfoStrategy {
    private static final Logging log = Logging.getLogging(BundleInfoStrategy.class);

    public static String selectBranchName(BundleInfo bundleInfo) {
        String branchName = bundleInfo.getBranchName();
        String nextBranchName = bundleInfo.getNextBranchName();
        if (nextBranchName != null && !nextBranchName.trim().isEmpty() && JOptionPane.showConfirmDialog(null, String.format("A new version `%s` is available!\nWould you like to update from `%s` to `%s` now?", nextBranchName, branchName, nextBranchName), "Release selection", 0) == 0) {
            return nextBranchName;
        }
        return branchName;
    }

    @NotNull
    public static String getDownloadUrl(BundleInfo bundleInfo, String baseUrl, Function<BundleInfo, String> branchSelector) {
        String branchUrl;
        if (bundleInfo.isMaster()) {
            log.info("Snapshot requested");
            branchUrl = baseUrl + "/autoupdate/";
        } else {
            String branchName = branchSelector.apply(bundleInfo);
            branchUrl = baseUrl + "/lts/" + branchName + "/autoupdate/";
        }
        return branchUrl;
    }
}

